<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Traits\NotificationsTrait;
// use App\Models\Phone;
// use App\Models\UserPackage;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\UserPackage;
use App\Models\Package;
use App\Models\PackageCounts;
use Illuminate\Mail\Message; 
use Illuminate\Support\Facades\Mail;
use App\Mail\RegisterMail;
use App\Mail\ContactUs;
class AuthController extends Controller
{
    use NotificationsTrait;
  
    public function contact_submit(Request $request){
        
        $data['status'] = 'error';
        $data['message'] = [];
        $data_errors= [];
        $array = ['name','email','phone_no','comment','service','country'];
        if(count(array_keys($request->post())) <3){
              $data['message'] = 'Something went wrong';
            return response()->json($data,500);
        }
        foreach(array_keys($request->post()) as $key=>$value){
            $data_error = [];
            if(in_array($value, $array)){
                if(empty($request->post($value))){
                   $data_errors[$value] = "{$value} field required";
                }
            }
        }
        if(count($data_errors) > 0){
            $data['message'] = $data_errors;
            return response()->json($data,400);
        }else{
            Mail::to('info@dissertationwriter.ai')->send(new ContactUs($request->post()));
             $data['status'] = 'success';
            $data['message'] = 'Request submited successfullty';
            return response()->json($data,400);
        }
    }
    public function register(Request $request)
    {
        $status_code = 404;
        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:8',
            'phone_no'=> 'required|string|min:8',
        
        ]);
        $data['first_name'] = "";
        $data['last_name'] = "";
        $data['email'] = "";
        $data['phone_no'] = "";
        $data['status'] = 'error';
        $data['message'] = 'Validation error found';
        $data['user_subscription'] = false;
        $data['password'] = "";
        if ($validator->fails()) {
            $status_code = 400;
            $error_message = $validator->messages();
            if ($error_message->first('first_name')) 
            {
                $data['first_name'] = $error_message->first('first_name');
            }
            if ($error_message->first('last_name')) 
            {
                $data['last_name'] = $error_message->first('last_name');
            }
            if ($error_message->first('email')) 
            {
                $data['email'] = $error_message->first('email');
            }
            if ($error_message->first('password')) 
            {
                $data['password'] = $error_message->first('password');
            }
            
            if ($error_message->first('phone_no')) 
            {
                $data['phone_no'] = $error_message->first('phone_no');
            }
            return response()->json($data, $status_code);
        }
        $data['first_name'] = $request->first_name??"";
        $data['last_name'] = $request->last_name??"";
        $data['email'] = $request->email;
        $data['phone_no'] = $request->phone_no;
        $user = User::create([
            'name' => $request->first_name . ' ' . $request->last_name,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'phone_no'=>$request->phone_no
        ]);
             $name = $request->first_name . ' ' . $request->last_name;
            $email = $request->email;
            $phone_no = $request->phone_no;
            Mail::to('info@dissertationwriter.ai')->send(new RegisterMail($name,$email,$phone_no,date('Y-m-d H:i:s')));
        $token = $user->createToken('auth_token')->plainTextToken;
        $status_code = 200;
        $data['status'] = 'success';
        $data['message'] = 'User Registered Successfully!';
        $data['verified'] = 0;
        $data['token'] = $token;
        $subscription = $user->subscriptions->first();
        if($subscription){
            $data['user_subscription'] = true;
        }else{
            $data['user_subscription'] = false;
            
        }
        
        return response()->json($data, $status_code);
    }


    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required|string|min:8',
        ]);
        $token = $request->bearerToken();
        $data['status'] = "error";
        $data['message'] = "";
        $data['email'] = "";
        $data['first_name'] = "";
        $data['last_name'] = "";
        $data['password'] = "";
        $data['access_token'] = "";
        // $data['role'] = "";
        $data['user_package'] = false;
        $data['user_subscription'] = false;
        $status_code = "";
        if ($validator->fails()) {
            $data['message'] = 'Validation error';
            $error_message = $validator->messages();
            if ($error_message->first('email')) {
                $data['email'] = $error_message->first('email');
            }
            if ($error_message->first('password')) {
                $data['password'] = $error_message->first('password');
            }
            $status_code = 400;
            return response()->json($data, $status_code);
        }
        if (!Auth::attempt($request->only('email', 'password'))) {
            $data['message'] = 'Unauthorized';
            return response()->json($data, 401);
        }
        $data['email'] = $request['email'];
     
        $user = User::where(['email' => $request['email']])->firstOrFail();

        $token = $user->createToken('auth_token')->plainTextToken;
        $data['first_name'] = $user->first_name??"";
        $data['last_name'] = $user->last_name??"";
        $user_package = UserPackage::where('user_id', $user->id)->first();
        if ($user_package) {
            $data['user_package'] = true;
        } else {
            $data['user_package'] = false;
        }
     
        $subscription = $user->subscriptions->first();
        if($subscription){
            $data['user_subscription'] = true;
        }else{
            $data['user_subscription'] = false;
            
        }
        
        $data['status'] = 'success';

        $data['message'] = 'you are loggedin';
        $data['access_token'] = $token;
        return response()->json($data, 200);
    }



    // method for user logout and delete token
    public function logout(Request $request)
    {
        try {
            $token = $request->bearerToken();
            // $check_token_exists = Auth::user($token)->id;

            $user =  auth('sanctum')->user();

            if ($user->id) {
                $data['status'] = 'success';
                $data['message'] = 'You have successfully logged out and the token was successfully deleted';
                //auth()->user()->tokens()->delete();
                $user->tokens()->where('id', $token)->delete();
            } else {
                $data['status'] = 'error';
                $data['message'] = 'User already logged out';
            }
        } catch (Exception $e) {
            $data['status'] = 'error';
            $data['message'] = 'something went wrong';
        }
        return $data;
    }


    public function profile(Request $request)
    {
        try {
            $user =  auth('sanctum')->user();
            if ($user->id) {
                $data['status'] = 'success';
                $user_profile = User::where('id', $user->id)->first();
                $data['name'] = $user_profile->name;
                $data['email'] = $user_profile->email;
                $data['phone_no'] = $user_profile->phone_no;
                $pckage = UserPackage::select(
                            'user_package.price',
                            'user_package.package_id',
                            'user_package.total_counts',
                            'user_package.credits',
                            // 'user_package.created_at as created_at',
                            'package_list.name as package_name',
                              'package_list.type',
                            // 'package_list.count',
                            'package_list.dissertation',
                            // 'user_package.dissertation as user_desertaion'
                    )
                    ->join('package_list', 'package_list.id', '=', 'user_package.package_id')
                    ->where('user_package.user_id', $user->id)
                    ->get();
                $data['package_detail'] = $pckage;
                $total_counts = 0;
                $dessertation = 0;
                $data_counts = [];
                $totals = [];
                $total_counts_real = 0;
                $total_dessertaion_real = 0;
                $total_counts = 0;
                $trial = 0;
                
                foreach($pckage as $key=>$value){
                        if($value->type == 'Free'){

                            // if($value->credits){
                            //     // $total_counts_real+=$value->credits;
                            //     $trial+=$value->credits;
                            // }
                            // if($value->credits==null){
                                $trial+=$value->user_desertaion;
                            // }
                            // $trial+=$value->user_desertaion;
                            // $total_counts+=$value->total_counts;
                        }
                            if($value->credits){
                                $total_counts_real+=$value->credits;
                                $total_dessertaion_real+=$value->credits;
                            }
                            if($value->credits==null){
                                $total_counts_real+=$value->count;
                            }
                            $dessertation+=$value->user_desertaion;
                            $total_counts+=$value->total_counts;
                        
                }
                if($dessertation != 0 ){
                 $data['user_package'] = true;
                }
                else{
                    $data['user_package'] = false;

                }
                
                
                
                // $subscription = $user->subscriptions->first();
                // if($subscription){
                //     $data['user_subscription'] = true;
                // }else{
                //     $data['user_subscription'] = false;
                    
                // }
              
                $data['totals'] = ['total_counts_real'=>$total_counts_real,
                                    'total_counts'=>$total_counts,
                                    'dissertation'=>$dessertation,
                                    'total_dissertation'=>$total_dessertaion_real,
                                    // 'subscription_status'=>($subscription? ($subscription->ends_at?false:true):true),'trial'=>$trial
                                    ];
            } else {
                $data['status'] = 'error';
                $data['message'] = 'User profile';
            }
        } catch (\Exception $e) {
            $data['status'] = 'error';
            $data['message'] = 'something went wrong';
        }
        return $data;
    }
}
