<?php
namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Interfaces\StripeSubscriptionRepositoryInterface;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use DB;

use function Laravel\Prompts\table;

class StripeSubscriptionController extends Controller
{    protected $apiUrl;
    private StripeSubscriptionRepositoryInterface $stripeSubscriptionRepositoryInterface;
    public function __construct(StripeSubscriptionRepositoryInterface $stripeSubscriptionRepositoryInterface)
    {
        $this->stripeSubscriptionRepositoryInterface = $stripeSubscriptionRepositoryInterface;
        $this->apiUrl = 'https://app.logopony.com/icons/default/?page=1&seed=1721894947239'; // Replace with your API URL

    }
    public function plans()
    {
        return $this->stripeSubscriptionRepositoryInterface->stripe_plans();
    }
    public function show($request)
    {
        return $this->stripeSubscriptionRepositoryInterface->show($request);
    }
    public function subscription(Request $request)
    {
        return $this->stripeSubscriptionRepositoryInterface->subscription($request);
    }
    public function user_subscriptions()
    {
       return $this->stripeSubscriptionRepositoryInterface->user_subscriptions();
    }
    public function default(Request $request)
    {
        return $this->stripeSubscriptionRepositoryInterface->default_subscription($request);
    }
    public function add_credits(Request $request){
        return $this->stripeSubscriptionRepositoryInterface->add_credits($request);
    }
    public function cancel_subscriptions(Request $request)
    {
        return $this->stripeSubscriptionRepositoryInterface->cancel_subscriptions($request);
    }
    public function resum_subscriptions(Request $request)
    {
       return $this->stripeSubscriptionRepositoryInterface->resum_subscriptions($request);
    }
    public function add_new_card(Request $request)
    {
       return $this->stripeSubscriptionRepositoryInterface->add_new_card($request);
    }
    public function client_order(Request $request){
       return $this->stripeSubscriptionRepositoryInterface->client_order_add($request);
    }
    private function downloadAndSaveImage($url, $path)
    {
        try {
            $response = Http::get($url);
            if ($response->successful()) {
                Storage::put($path, $response->body());
            } else {
                Log::error('Failed to download image', ['url' => $url, 'status' => $response->status()]);
            }
        } catch (\Exception $e) {
            Log::error('Exception while downloading image', ['url' => $url, 'message' => $e->getMessage()]);
        }
    }
  
    public function downloadimg(Request $request){
        $path = storage_path('ap p/icons.json');
        $path = storage_path('app/icons.json');
        $json = file_get_contents($path);
        $data = json_decode($json, true);
       
        foreach ($data['icons'] as $icon) {
            if (is_array($icon) && isset($icon['id'])) {
                
                $replacedString = str_replace('_', ' ', $icon['id']);
                // Save icon data to database
                $carregistration = [
                    'id' => $replacedString,
                    'icon_url' => $icon['icon_url'],
                    'preview_url' => $icon['preview_url_84'],
                ];
        
                $post = DB::table('icons')->insert($carregistration);
                // Download and save icon image
                $iconUrl = $data['icon_path'] . '/' . $icon['icon_url'];
                $imageUrl = $data['image_path'] . '/' . $icon['preview_url_84'];

                $this->downloadAndSaveImage($iconUrl, 'icons/' . $icon['icon_url'].''.'.svg');
                $this->downloadAndSaveImage($imageUrl, 'previews/' . $icon['preview_url_84'].''.'.png');
            } else {
                // Log an error if the icon is not an array or 'id' is missing
                Log::error('Invalid icon data', ['icon' => $icon]);
                return response()->json(['message' => 'Invalid icon data'], 400);
            }
        }


}
}
