<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\StripeSubscriptionRepositoryInterface;
use App\Http\Traits\PlanTrait;
use App\Http\Traits\StripeTrait;
use App\Models\User;
use App\Http\Traits\PaymentLogsTrait;
use App\Models\PaymentLogs;
use App\Models\UserPackage;
use App\Models\Refer;
use App\Models\Package;
use App\Models\Orders;
use Stripe\Stripe;
use Laravel\Cashier\Cashier;
use Illuminate\Mail\Message;
use Illuminate\Support\Facades\Mail;
use App\Mail\ClientOrderMail;
use App\Mail\ConfirmationMailToClient;
use App\Models\PackageCounts;
use Illuminate\Support\Facades\Validator;
use DB;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Http;
use Illuminate\Support\Facades\Auth;

class StripeSubscriptionRepository implements StripeSubscriptionRepositoryInterface
{
    use PlanTrait, PaymentLogsTrait, StripeTrait;
    public function stripe_plans()
    {
        $data['status'] = 'success';
        $data['message'] = 'plan found';
        $data['data'] = [];
        $data['data'] = $this->plans();
        return response()->json($data);
    }
    public function show($request)
    {
        $intent = auth('sanctum')->user()->createSetupIntent();
        $data['status'] = 'success';
        $data['intent'] = $intent;
        $plan = $this->plan_slug($request);
        $PaymentLogs = new PaymentLogs();
        $PaymentLogs->package_id = $plan->id;
        $PaymentLogs->user_id =  auth('sanctum')->user()->id;
        $PaymentLogs->status = 'unpaid';
        $PaymentLogs->amount =  $plan->price;
        $PaymentLogs->hits =   Package::find($plan->id)->count;
        $PaymentLogs->dissertation =   Package::find($plan->id)->dissertation;
        $PaymentLogs->type =   "subscription";
        $PaymentLogs->save();
        $data['plan'] = $plan;
        return response()->json($data);
    }
    public function subscription($request)
    {
        $data['status'] = 'success';
        $data['message'] = 'Subscription Success!';
        $data['data'] = [];
        $plan = $this->plan($request->plan);
        $data['plan'] =  $plan;
        $data['refer'] = "";
        $data['subscriptions'] = [];
        try {
            $subscriptions =  auth('sanctum')->user()->newSubscription($request->plan, $plan->stripe_plan)->create($request->token);
            $data['subscriptions'] =  $subscriptions;
            $PaymentLogs = PaymentLogs::where(['package_id' => $request->plan, 'user_id' => auth('sanctum')->user()->id, 'status' => 'unpaid', 'type' => 'subscription'])->orderBy('id', 'desc')->first();
            $payment_status = "";
            if ($PaymentLogs) {
                $PaymentLogs->status = 'paid';
                $PaymentLogs->save();
            }
            if ($request->refer) {
                $users = Refer::where('refer_encoded_code', $request->refer)->orderBy('id', 'desc')->first();
                if ($users) {
                    $user = User::find(auth('sanctum')->user()->id);
                    $user->referred_by = $users->user_id;
                    $user->save();
                }
            }
        } catch (\Exception $e) {
            $data['status'] = 'error';
            $data['message'] = 'Subscription failed: ' . $e->getMessage();
            return response()->json($data, 500);
        }
        return response()->json($data);
    }
    public function user_subscriptions()
    {
        try {

            Stripe::setApiKey("sk_test_51OVWwKGlwbnEelITOuPxv42pCeQ0T3FnWFbfCIuWawHuUh9luoffq5MmNXOj1zKRfPaWqxHLALvflcu8lctboT6V00qHsaPa6c");
            $user = auth('sanctum')->user();
            $stripe = \Stripe\Subscription::all(['customer' => $user->stripe_id]);
            $datas['status'] = 'success';
            $datas['message'] = 'Subscription Found Successfully';
            $datas['data'] = [];
            $data['id'] =   $stripe->data[0]->id;
            $data["created"] = date("Y-m-d", $stripe->data[0]->created);
            $data["current_period_end"] = date("Y-m-d H:i:s", $stripe->data[0]->current_period_end);
            $data["current_period_start"] = date("Y-m-d H:i:s", $stripe->data[0]->current_period_start);
            $data["currency"] = $stripe->data[0]->currency;
            $data["collection_method"] = $stripe->data[0]->collection_method;
            $data["plan_amount"] = $stripe->data[0]->items->data[0]->plan;
            $data["interval"] = $stripe->data[0]->items->data[0]->plan->interval;
            $data["interval_count"] = $stripe->data[0]->items->data[0]->plan->interval_count;
            $data["product"] = $stripe->data[0]->items->data[0]->plan->product;
            $paymentMethods = \Stripe\PaymentMethod::all([
                'customer' => $user->stripe_id,
                'type' => 'card',
            ]);
            $data['cards_details'] = [];
            $default =   \Stripe\Customer::retrieve($user->stripe_id)->invoice_settings->default_payment_method;
            foreach ($paymentMethods->data as $key => $value) {
                $result = [];
                $result['id'] = $value->id;
                $result['default'] = ($value->id == $default ? true : false);
                $result['brand'] = $value->card->brand;
                $result['last4'] = "************" . $value->card->last4;
                $result['exp'] = $value->card->exp_month . '/' . $value->card->exp_year;
                $data['cards_details'][] = $result;
            }
            $datas['data'] = $data;
            return response()->json($datas);
        } catch (\Exception $e) {
            $datas['staus'] = 'error';
            $datas['message'] = $e->getMessage();
            $datas['data'] = [];
            return response()->json($datas);
        }
    }
    public function default_subscription($request)
    {
        try {
            Stripe::setApiKey("sk_test_51OVWwKGlwbnEelITOuPxv42pCeQ0T3FnWFbfCIuWawHuUh9luoffq5MmNXOj1zKRfPaWqxHLALvflcu8lctboT6V00qHsaPa6c");
            $user = auth('sanctum')->user();

            $customer = \Stripe\Customer::retrieve($user->stripe_id);
            if ($customer) {
                $customer->invoice_settings->default_payment_method = $request->payment_method;
                $customer->save();
            }
            $data['status'] = 'success';
            $data['message'] = 'card updated successfully';
            return response()->json($data);
        } catch (\Exception $e) {
            $data['status'] = 'error';
            $data['message'] = $e->getMessage();
            return response()->json($data);
        }
    }
    public function add_credits($request)
    {
        try {
            $user = auth('sanctum')->user();
            Stripe::setApiKey("sk_test_51OVWwKGlwbnEelITOuPxv42pCeQ0T3FnWFbfCIuWawHuUh9luoffq5MmNXOj1zKRfPaWqxHLALvflcu8lctboT6V00qHsaPa6c");
            $intent = \Stripe\PaymentIntent::create([
                'customer' => $user->stripe_id,
                'setup_future_usage' => 'off_session',
                'amount' => ($request->price * 100),
                'currency' => 'usd',
                'automatic_payment_methods' => [
                    'enabled' => 'true',
                    'allow_redirects' => 'never'
                ],
            ]);
            $package_id = $user->user_packages[0]->package_id;
            $package_data = Package::find($package_id);
            $check_allow = $package_data->credits_allow;
            $PaymentLogs = new PaymentLogs();
            $PaymentLogs->package_id = $package_id;
            $PaymentLogs->user_id =  auth('sanctum')->user()->id;
            $PaymentLogs->status = 'unpaid';
            $PaymentLogs->amount =  $request->price;
            $PaymentLogs->type =  "credits";
            $hits = 0;
            $dissertation = 0;
            $credits = 0;
            if ($check_allow == 1) {
                $hits = $request->hits;
                $credits = $hits;
            }
            if ($check_allow == 2) {
                $dissertation =   $request->hits;
                $credits = $dissertation;
            }
            $PaymentLogs->hits =   $hits;
            $PaymentLogs->dissertation =    $dissertation;
            $PaymentLogs->credits =    $credits;
            $PaymentLogs->save();

            $customer = \Stripe\Customer::retrieve($user->stripe_id);
            $paymentIntent = \Stripe\PaymentIntent::retrieve($intent->id);
            $paymentIntent->confirm([
                'payment_method' => $customer->invoice_settings->default_payment_method,
            ]);
            $payment_logs = new PaymentLogs();
            $payments = $payment_logs->where(['package_id' => $package_id, 'user_id' => auth('sanctum', 'type')->user()->id, 'type' => 'credits'])->orderBy('id', 'desc')->first();
            $payments->status = 'paid';
            $payments->save();
            $data['status'] = 'success';
            $data['message'] = "credits add successfully!";
            return response()->json($data);
        } catch (\Exception $e) {
            $data['status'] = 'error';
            $data['message'] = $e->getMessage();
            return response()->json($data);
        }
    }
    public function add_new_card($request)
    {
        try {
            $data['status'] = 'success';
            $data['message'] = 'card added successfully';
            $user = auth('sanctum')->user();
            $paymentMethod = $user->addPaymentMethod($request->input('token'));
            $user->updateDefaultPaymentMethod($paymentMethod->id);
            return response()->json($data, 200);
        } catch (\Exception $e) {
            $data['status'] = 'error';
            $data['message'] = $e->getMessage();
            return response()->json($data, 500);
        }
    }
    public function cancel_subscriptions($request)
    {
        $subscription = $this->cancel();
        return response()->json(['status' => 'success', 'message' => 'Subscription Cancelled Successfully!', 'subscription' => $subscription]);
    }
    public function resum_subscriptions($request)
    {
        $subscription = $this->resume();
        return response()->json(['status' => 'success', 'message' => 'Subscription Resumed Successfully!', 'subscription' => $subscription]);
    }
    public function client_order_add($request)
    {
        try {
            $data['status'] = 'success';
            $data['message'] = 'client order added successfully!';
            $validator = Validator::make($request->all(), [
                'topic' => 'required|string',
                'education_level' => 'required',
                'discipline' => 'required',
                'methodology' => 'required',
                'total_word_count' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 'error';
                $data['message'] = 'client order not added successfully!';
                $status_code = 400;
                $error_message = $validator->messages();
                if ($error_message->first('topic')) {
                    $data['topic'] = $error_message->first('topic');
                } else {
                    $data['topic'] = $request->topic;
                }
                if ($error_message->first('education_level')) {
                    $data['education_level'] = $error_message->first('education_level');
                } else {
                    $data['education_level'] = $request->education_level;
                }
                if ($error_message->first('discipline')) {
                    $data['discipline'] = $error_message->first('discipline');
                } else {
                    $data['discipline'] = $request->discipline;
                }
                if ($error_message->first('methodology')) {
                    $data['methodology'] = $error_message->first('methodology');
                } else {
                    $data['methodology'] = $request->methodology;
                }
                if ($error_message->first('total_word_count')) {
                    $data['total_word_count'] = $error_message->first('total_word_count');
                } else {
                    $data['total_word_count'] = $request->total_word_count;
                }
                return response()->json($data, $status_code);
            }

            $user = auth('sanctum')->user();
            $orders = new Orders();
            $orders->topic = $request->topic;
            $orders->education_level = $request->education_level;
            $orders->discipline = $request->discipline;
            $orders->methodology = $request->methodology;
            $orders->total_word_count = $request->total_word_count;
            $orders->reference_style = $request->reference_style;
            $orders->deadline = $request->deadline;
            $orders->additional_information = $request->additional_information;
            $orders->package_id =  $request->package_id;
            $orders->created_by =  $user->id;
            $orders->user_id =  $user->id;
            $orders->created_at =  date('Y-m-d H:i:s');
            $orders->save();

            if ($request->fil) {
                $documents_data = [];

                foreach ($request->file as $key => $file) {
                    $url = Storage::disk('public')->putFile('documents', $file);
                    $data = [];
                    $data['order_id'] = $orders->id;
                    $data['url'] = $url;
                    $documents_data[] = $data;
                }

                DB::table('order_documents')->insert($documents_data);
            }

            
            $data['status'] = 'success';
            $data['message'] = 'client order added successfully!';
            $data['url'] =  '';
            $result = Orders::with(['order_documents', 'user'])->where('orders.id', $orders->id)->first();
            $packagetype = Package::where('id', $request->package_id)->select('name', 'amount')->first();
            $useremail = user::where('id', $user->id)->select('email')->first();
            Mail::to('creatics.developer2@gmail.com')->send(new ClientOrderMail($result, $packagetype));
            Mail::to($useremail)->send(new ConfirmationMailToClient($result, $result->date));

            return response()->json($data, 200);
        } catch (\Exception $e) {
            $data['status'] = 'error';
            $data['message'] = $e->getMessage();
            return response()->json($data, 500);
        }
    }


    public function stripePost($request)
    {
        try {


            $user =  auth('sanctum')->user();
            if ($user->id) {
                $package = Package::where('id', $request->package_id)->first();
                \Stripe\Stripe::setApiKey('sk_test_51OVWwKGlwbnEelITOuPxv42pCeQ0T3FnWFbfCIuWawHuUh9luoffq5MmNXOj1zKRfPaWqxHLALvflcu8lctboT6V00qHsaPa6c');
                $session = \Stripe\Checkout\Session::create([
                    'payment_method_types' => ['card'],
                    'line_items'           => [
                        [
                            'price_data'  => [
                                'product_data' => [
                                    'name' => $user->name,
                                ],
                                'unit_amount'  => ($package->amount) * 100,
                                'currency'     => 'USD',
                            ],
                            'quantity'    => 1,

                        ],
                    ],
                    'mode'                 => 'payment',
                    'success_url'          =>  url('http://staggingcreatics.com/ai_project/dissertation_api/public/payment-success/{CHECKOUT_SESSION_ID}'),
                    'cancel_url'           => 'https://localhost/dissertationwriter.ai/cancel-payment',
                ]);

                // Orders::where('id', $request->id)->update(['session' => $session->id]);
                return $session->url;
            } else {
                return false;
            }
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
        
    }

    public function generateLogo($request)
    {
        // dd('create logo');
        // $validate = Validator::make($request->all(), [
		// 	'prompt' => 'required',
		// ]);
		// if ($validate->fails()) {
		// 	return response()->json($validate->errors(), 400);
		// }
        $response = true;
        // $response = Http::withHeaders([
        //     'Authorization' => 'Bearer ' . 'sk-proj-Dei7vrqW9271yUxIUsOHT3BlbkFJaLn5FCynyAMTyV7pFwJE',
        //     ])->post('https://api.openai.com/v1/images/generations', [
        //         'prompt' => $request->prompt,
        //     'n' => 1,
        //     'size' => '1024x1024',
        // ]);
        $user =  auth('sanctum')->user();
        $userId = $user->id;

        // etc.
        if ($response == 1) {
                // dd('ds');

                // $packagecount = PackageCounts();
            // return response()->json($response->json());
        } else {
            return response()->json(['error' => 'Error generating image'], 500);
        }
    }
}
