<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Illuminate\Database\QueryException;
use PDOException;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

public function render($request, Throwable $exception)
{
    if ($exception instanceof QueryException) {
        $pdoException = $exception->getPrevious();

        if ($pdoException instanceof PDOException) {
            if (in_array($pdoException->getCode(), ['2006', '2013'])) {
                // Attempt to reconnect
                \DB::reconnect();
                // Optionally, retry the query
                // return some response or redirect
            }
        }
    }

    return parent::render($request, $exception);
}
}
