<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Traits\NotificationsTrait;
// use App\Models\Phone;
// use App\Models\UserPackage;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\UserPackage;
use App\Models\Package;
use App\Models\Website;
use App\Models\PackageCounts;
use Illuminate\Mail\Message; 
use Log;
use Illuminate\Support\Facades\Mail;
use App\Mail\RegisterMail;
use Illuminate\Validation\Rule;
use App\Mail\ContactUs;


use App\Models\SmtpSetting;
use Illuminate\Support\Facades\Config;
class AuthController extends Controller
{
    use NotificationsTrait;
  
    public function contact_submit(Request $request){
        
        $data['status'] = 'error';
        $data['message'] = [];
        $data_errors= [];
        $array = ['name','email','phone_no','comment','service','country'];
        if(count(array_keys($request->post())) <3){
              $data['message'] = 'Something went wrong';
            return response()->json($data,500);
        }
        foreach(array_keys($request->post()) as $key=>$value){
            $data_error = [];
            if(in_array($value, $array)){
                if(empty($request->post($value))){
                   $data_errors[$value] = "{$value} field required";
                }
            }
        }
        if(count($data_errors) > 0){
            $data['message'] = $data_errors;
            return response()->json($data,400);
        }else{
                 $domain = $request->domain ?? null;
                           
            if($domain){
              $smtpSettings = SmtpSetting::where('domain',$domain)->first();
                    if ($smtpSettings) {
                        Config::set('mail.mailers.smtp.transport', $smtpSettings->mail_mailer);
                        Config::set('mail.mailers.smtp.host', $smtpSettings->mail_host);
                        Config::set('mail.mailers.smtp.port', $smtpSettings->mail_port);
                        Config::set('mail.mailers.smtp.username', $smtpSettings->mail_username);
                        Config::set('mail.mailers.smtp.password', $smtpSettings->mail_password);
                        Config::set('mail.mailers.smtp.encryption', $smtpSettings->mail_encryption);
                        Config::set('mail.from.address', $smtpSettings->mail_from_address);
                        Config::set('mail.from.name', $smtpSettings->mail_from_name);
                    }
                
                    $recipientEmail = $smtpSettings->recipient_email; // Default if not set
                
                    // Mail::to('info@easylogomaker.ai')->send(new ContactUs($request->post()));
                        Mail::to($recipientEmail)->send(new ContactUs($request->post(),$smtpSettings->mail_host));
                     $data['status'] = 'success';
                    $data['message'] = 'Request submited successfullty';
                    return response()->json($data,400);
            }
        }
    }
    
    public function register(Request $request)
    {
        $website = Website::where('domain', $request->domain)->first();
        
        if (!$website) {
            return response()->json(['error' => 'Domain not found in websites table.'], 404);
        }
        
        $status_code = 404;
        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            // 'email' => 'required|string|email|max:255|unique:users',
            'email' => [
                'required',
                'string',
                'email',
                'max:255',
                Rule::unique('users')->where(function ($query) use ($website) {
                    return $website ? $query->where('website_id', $website->id) : $query;
                }),
            ],
            'password' => 'required|string|min:8',
            'phone_no'=> 'required|string|min:8',
        
        ]);
        
        $data['first_name'] = "";
        $data['last_name'] = "";
        $data['email'] = "";
        $data['phone_no'] = "";
        $data['status'] = 'error';
        $data['message'] = 'Validation error found';
        $data['user_subscription'] = false;
        $data['password'] = "";
        if ($validator->fails()) {
            $status_code = 400;
            $error_message = $validator->messages();
            if ($error_message->first('first_name')) 
            {
                $data['first_name'] = $error_message->first('first_name');
            }
            if ($error_message->first('last_name')) 
            {
                $data['last_name'] = $error_message->first('last_name');
            }
            if ($error_message->first('email')) 
            {
                $data['email'] = $error_message->first('email');
            }
            if ($error_message->first('password')) 
            {
                $data['password'] = $error_message->first('password');
            }
            
            if ($error_message->first('phone_no')) 
            {
                $data['phone_no'] = $error_message->first('phone_no');
            }
            return response()->json($data, $status_code);
        }
        
        
        $data['first_name'] = $request->first_name ?? "";
        $data['last_name'] = $request->last_name ?? "";
        $data['email'] = $request->email;
        $data['phone_no'] = $request->phone_no;
        $user = User::create([
            'website_id' => $website->id ?? '0',
            'name' => $request->first_name . ' ' . $request->last_name,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'phone_no'=>$request->phone_no
        ]);
        // return $user;
        
        
             $name = $request->first_name . ' ' . $request->last_name;
            $email = $request->email;
            $phone_no = $request->phone_no;
            
            $domain = $request->domain ?? null;

            if($domain){
                $smtpSettings = SmtpSetting::where('domain',$domain)->first();   
                // dd($smtpSettings);
                if ($smtpSettings) {
                    Config::set('mail.mailers.smtp.transport', $smtpSettings->mail_mailer ?? '');
                    Config::set('mail.mailers.smtp.host', $smtpSettings->mail_host ?? '');
                    Config::set('mail.mailers.smtp.port', $smtpSettings->mail_port ?? '');
                    Config::set('mail.mailers.smtp.username', $smtpSettings->mail_username ?? '');
                    Config::set('mail.mailers.smtp.password', $smtpSettings->mail_password ?? '');
                    Config::set('mail.mailers.smtp.encryption', $smtpSettings->mail_encryption ?? '');
                    Config::set('mail.from.address', $smtpSettings->mail_from_address ?? '');
                    Config::set('mail.from.name', $smtpSettings->mail_from_name ?? '');

                    $recipientEmail = $smtpSettings->recipient_email ?? ''; // Default if not set
                    // Mail::to('info@easylogomaker.ai')->send(new RegisterMail($name,$email,$phone_no,date('Y-m-d H:i:s')));
                    Mail::to($recipientEmail)->send(new RegisterMail($name, $email, $phone_no, date('Y-m-d H:i:s'),$smtpSettings->mail_host));
                }
            }
            
            
        $token = $user->createToken('auth_token')->plainTextToken;
        $status_code = 200;
        $data['status'] = 'success';
        $data['message'] = 'User Registered Successfully!';
        $data['verified'] = 0;
        $data['token'] = $token;
        $subscription = $user->subscriptions->first();
        if($subscription){
            $data['user_subscription'] = true;
        }else{
            $data['user_subscription'] = false;
            
        }
        return response()->json($data, $status_code);
    }


    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required|string|min:8',
        ]);
        $token = $request->bearerToken();
        $data['status'] = "error";
        $data['message'] = "";
        $data['email'] = "";
        $data['first_name'] = "";
        $data['last_name'] = "";
        $data['password'] = "";
        $data['access_token'] = "";
        // $data['role'] = "";
        $data['user_package'] = false;
        $data['user_subscription'] = false;
        $status_code = "";
        if ($validator->fails()) {
            $data['message'] = 'Validation error';
            $error_message = $validator->messages();
            if ($error_message->first('email')) {
                $data['email'] = $error_message->first('email');
            }
            if ($error_message->first('password')) {
                $data['password'] = $error_message->first('password');
            }
            $status_code = 400;
            return response()->json($data, $status_code);
        }
        if (!Auth::attempt($request->only('email', 'password'))) {
            $data['message'] = 'Unauthorized';
            return response()->json($data, 401);
        }
        $data['email'] = $request['email'];

        $website = Website::where('domain', $request->domain)->first();
        if (!$website) {
            $data['message'] = 'Domain not found in websites table.';
            return response()->json($data, 404);
        }

        $user = User::where(['email' => $request->email, 'website_id' => $website->id])->first();
        if (!$user) {
            $data['message'] = 'User not found';
            return response()->json($data, 404);
        }
        // $user = User::where(['email' => $request['email']])->firstOrFail();
        // dd($user);

        $token = $user->createToken('auth_token')->plainTextToken;
        $data['first_name'] = $user->first_name??"";
        $data['last_name'] = $user->last_name??"";
        $user_package = UserPackage::where('user_id', $user->id)->first();
        if ($user_package) {
            $data['user_package'] = true;
        } else {
            $data['user_package'] = false;
        }
     
        $subscription = $user->subscriptions->first();
        if($subscription){
            $data['user_subscription'] = true;
        }else{
            $data['user_subscription'] = false;
            
        }
        
        $data['status'] = 'success';

        $data['message'] = 'you are loggedin';
        $data['access_token'] = $token;
        return response()->json($data, 200);
    }



    // method for user logout and delete token
    public function logout(Request $request)
    {
        try {
            $token = $request->bearerToken();
            // $check_token_exists = Auth::user($token)->id;

            $user =  auth('sanctum')->user();

            if ($user->id) {
                $data['status'] = 'success';
                $data['message'] = 'You have successfully logged out and the token was successfully deleted';
                //auth()->user()->tokens()->delete();
                $user->tokens()->where('id', $token)->delete();
            } else {
                $data['status'] = 'error';
                $data['message'] = 'User already logged out';
            }
        } catch (Exception $e) {
            $data['status'] = 'error';
            $data['message'] = 'something went wrong';
        }
        return $data;
    }


    public function profile(Request $request)
    {
   //     try {
            $website = Website::where('domain', $request->domain)->first();
            if (!$website) {
                return response()->json(['error' => 'Domain not found in websites table.'], 404);
            }
            $user =  auth('sanctum')->user();
            if ($user->id) {
                $data['status'] = 'success';
                $user_profile = User::where('id', $user->id)->first();
                $data['name'] = $user_profile->name;
                $data['email'] = $user_profile->email;
                $data['phone_no'] = $user_profile->phone_no;
                $pckage = UserPackage::select(
                            'user_package.price',
                            'user_package.package_id',
                            'user_package.total_counts',
                            'user_package.credits',
                            'user_package.created_at as created_at',
                            'package_list.name as package_name',
                              'package_list.type',
                            'package_list.count',
                            'package_list.dissertation',
                            'user_package.dissertation as user_desertaion',
                            'package_list.credits_allow',
                            'package_list.dissertation as dissertation_credits'
                    )
                    ->join('package_list', 'package_list.id', '=', 'user_package.package_id')
                    ->where('user_package.user_id', $user->id)
                    ->get();
                $data['package_detail'] = $pckage;
                $total_counts = 0;
                $dessertation = 0;
                $data_counts = [];
                $totals = [];
                $total_counts_real = 0;
                $total_dessertaion_real = 0;
                $used_dissertation = 0;

                $trial = 0;
                // dd($pckage);
                
                if (in_array($website->domain, ['dissertationwriter.ai', 'domyassignments.ai', 'dissertationhelp.ai', 'aitheisiwirter.ai', 'stagging.dissertationwriter.ai', 'staging.domyassignment.ai', 'staging.dissertationhelp.ai', 'stagging.aitheisiwirter.ai'])) {
                    foreach($pckage as $key => $value) {
                        // Accumulate total counts and dissertation values
                        $total_counts_real += $value->count;
                        $total_dessertaion_real += $value->dissertation;
            
                        // Accumulate the counts that can be used
                        if ($value->total_counts) {
                            $total_counts += ($value->total_counts);
                        }
            
                        if ($value->user_desertaion) {
                            $dessertation += ($value->user_desertaion);
                        }
            
                        // Deduct from dissertation if used
                        if ($used_dissertation < $total_dessertaion_real && $value->user_desertaion > 0) {
                            $remaining_dissertation = $total_dessertaion_real - $used_dissertation;
                            $use_dissertation = min($remaining_dissertation, $value->user_desertaion); // Min between remaining and available
                            $used_dissertation += $use_dissertation; // Track the total used dissertation
                        }
                    }
                }
                
                // if (in_array($website->domain, ['businesslogomaker.ai', 'easylogomaker.ai', 'customlogo.ai', 'stagging.easylogomaker.ai', 'stagging.customlogo.ai', 'staging.businesslogomaker.ai'])) {
                //     foreach ($pckage as $key => $value) {
                //         // Check if the package type is "Free" and handle separately
                //         if ($value->type == 'Free') {
                //             // If credits exist, add to trial counts
                //             if ($value->credits) {
                //                 $trial += $value->credits;
                //             }
                //             continue; // Skip further processing for free packages
                //         }
                    
                //         // Accumulate dissertation and total counts only for valid packages
                //         if ($value->total_counts) {
                //             $total_counts += $value->total_counts;
                //         }
                    
                //         // Accumulate dissertation if user-specific dissertation exists
                //         if ($value->user_desertaion) {
                //             $dessertation += $value->user_desertaion; // Use user-specific field
                //         } elseif ($value->dissertation) {
                //             $dessertation += $value->dissertation; // Use package field otherwise
                //         }
                    
                //         // Accumulate real total counts for all packages
                //         $total_counts_real += $value->count;
                    
                //         // Accumulate real total dissertations for all packages
                //         $total_dessertaion_real += $value->dissertation;
                //     }
                // }
                if (in_array($website->domain, ['businesslogomaker.ai', 'easylogomaker.ai', 'customlogo.ai', 'stagging.easylogomaker.ai', 'stagging.customlogo.ai', 'staging.businesslogomaker.ai'])) {
                    foreach ($pckage as $key => $value) {
                        // Skip free packages for further processing
                        if ($value->type == 'Free') {
                            continue; // Skip free packages
                        }
    
                        // Accumulate dissertation and total counts only for valid packages
                        if ($value->total_counts) {
                            $total_counts += $value->total_counts;
                        }
    
                        // Accumulate dissertation if user-specific dissertation exists
                        if ($value->user_desertaion) {
                            $dessertation += $value->user_desertaion; // Use user-specific dissertation
                        } elseif ($value->dissertation) {
                            $dessertation += $value->dissertation; // Use package field if no user-specific dissertation
                        }
    
                        // Accumulate real total counts for all packages
                        $total_counts_real += $value->count;
    
                        // Accumulate real total dissertations for all packages
                        $total_dessertaion_real += $value->dissertation;
                    }
                }
                if($dessertation != 0 ){
                    $data['user_package'] = true;
                }
                else{
                    $data['user_package'] = false;
                }
                
                // $subscription = $user->subscriptions->first();
                // if($subscription){
                //     $data['user_subscription'] = true;
                // }else{
                //     $data['user_subscription'] = false;
                    
                // }
              
                $data['totals'] = ['total_counts_real'=>$total_counts_real,
                                    'total_counts'=>$total_counts,
                                    'dissertation'=>$dessertation,
                                    'usage_dissertation'=>$dessertation,
                                    'total_dissertation'=>$total_dessertaion_real,
                                    'trial'=>$trial
                                    // 'subscription_status'=>($subscription? ($subscription->ends_at?false:true):true),'trial'=>$trial
                                    ];
                //   $data['totals'] = ['total_counts_real'=>$total_counts_real,
                //                     'total_counts'=>$total_counts,
                //                     'dissertation'=>$dessertation,
                //                     'total_dissertation'=>$total_dessertaion_real,
                //                     'subscription_status'=>($subscription? ($subscription->ends_at?false:true):true),'trial'=>$trial
                //                     ];
            } else {
                $data['status'] = 'error';
                $data['message'] = 'User profile';
            }
        // } catch (\Exception $e) {
        //     $data['status'] = 'error';
        //     $data['message'] = 'something went wrong';
        // }
        return $data;
    }
}
