<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Package;
use App\Models\UserPackage;
use App\Models\Website;
use Illuminate\Http\Request;
use App\Models\PaymentLogs;
use App\Models\User;
use App\Models\Orders;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Stripe;

use App\Http\Interfaces\PaymentRepositoryInterface;
use Illuminate\Support\Facades\Validator;
use DB;
use Illuminate\Mail\Message; 
use Illuminate\Support\Facades\Mail;
use App\Mail\ClientOrderMail;
class PackageController extends Controller
{
    private $paymentRepository;
    public function __construct(PaymentRepositoryInterface $paymentRepository){
        $this->paymentRepository = $paymentRepository;
    }
    public function index(Request $request)
    {
        return view('product.index');
    }
    // public function package_list(Request $request)
    // {
    //     $status_code = 404;

    //     $website = Website::where('domain', $request->domain)->first();
    //     if (!$website) {
    //         $data['error'] = "Domain not found in websites table.";
    //         return response()->json($data, 404);
    //     }
    //     // dd($website);
    //     $package = Package::select('id','name','image','description','amount','type','count', 'website_id')->where('website_id', $website->id)->where('status','ACTIVE')->get();
    //     $package_data = [];
    //     foreach($package as $key=>$value){
    //      if($value->id != 5){
    //          $package_data[] = $value;
    //      }else{
    //          array_unshift($package_data, $value);
    //      } 
    //     }
        
    //     if ($package_data) {
    //         $status_code = 200;
    //         $data['status'] = 'success';
    //         $data['message'] = 'Package Fatch successfully';
    //         $data['package'] = $package_data;
    //     } else {
    //         $data['message'] = 'Package Data Not Found';
    //     }
    //     return response()->json($data, $status_code);
    // }
    
    public function package_list(Request $request)
    {
        $status_code = 404;
        
        $website = Website::where('domain', $request->domain)->first();
        if (!$website) {
            $data['error'] = "Domain not found in websites table.";
            return response()->json($data, 404);
        }
        $packages = Package::select('id', 'name', 'image', 'description', 'amount', 'type', 'count')
            ->where('website_id', $website->id)
            ->where('status', 'ACTIVE')
            ->get();
    
        $package_data = [];
    
        foreach ($packages as $key => $value) {
            if ($value->type == 'Free') {
                continue;
            }
    
            if ($value->id != 5) {
                $package_data[] = $value;
            } else {
                array_unshift($package_data, $value);
            }
        }
    
        if ($package_data) {
            $status_code = 200;
            $data['status'] = 'success';
            $data['message'] = 'Package fetched successfully';
            $data['package'] = $package_data;
        } else {
            $data['message'] = 'Package Data Not Found';
        }
    
        return response()->json($data, $status_code);
    }

    public function user_package(Request $request)
    {

        $status_code = 404;
        $user_package = UserPackage::select('id','name','image','description','amount','type','count')->where('package_id', $request->package_id)->get();

        if ($user_package) {
            $status_code = 200;
            $data['status'] = 'success';
            $data['message'] = 'Package Fatch successfully';
            $data['package'] = $user_package;
        } else {
            $data['message'] = 'Package Data Not Found';
        }



        return response()->json($data, $status_code);
    }

    // public function register_user_package(Request $request){
    //   return $this->packageRepository->register_package($request);
    // }
    public function register_user_package_old(Request $request)
    {
        try {
            $user =  auth('sanctum')->user();
            if ($user->id) {
                $data['status'] = 'success';
                $data['message'] = '';

                $package_get = Package::select('id', 'count')->where('id', $request->package_id)->first();
                
                $package_sub = UserPackage::insert([
                    'user_id' => $user->id,
                    'package_id' => $request->package_id,
                    'total_counts' => $package_get->count,
                    'created_at' => Date('Y-m-d h:i:s'),
                    'updated_at' => Date('Y-m-d h:i:s'),
                ]);

                $status_code = 200;
                $data['status'] = 'success';
                $data['message'] = 'Package subscribe successfully';
            } else {
                $data['status'] = 'error';
                $data['message'] = 'User already logged out';
            }
        } catch (\Exception $e) {
            $data['status'] = 'error';
            $data['message'] = 'Please Log in the user';
        }
        return $data;
    }

    public function stripePost(Request $request){
        return $this->paymentRepository->stripe_post($request);
    }

    public function success($session){
        
        // $result = Orders::with(['order_documents','user'])->where('orders.session',$session)->first();
        // Mail::to('creatics.developer2@gmail.com')->send(new ClientOrderMail($result));
         $PaymentLogs = new PaymentLogs();
        $payment_logsData = $PaymentLogs->where('session_id',$session)->first();
        $payment_logsData->status = "paid";
        $payment_logsData->save();
        
        $package = Package::find($payment_logsData->package_id);
        if ($package) {
            $website = Website::find($package->website_id);
            if ($website && $website->domain) {
                return redirect("https://{$website->domain}/payment-success");
            }
        }
        
        // return redirect('https://stagging.easylogomaker.ai/payment-success');
        return redirect()->back();
    }
   
    public function stripePost_old(Request $request)
    {   
        $user =  auth('sanctum')->user();
        if ($user->id) {
            $package = Package::where('id', $request->package_id)->first();
            \Stripe\Stripe::setApiKey('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');
            $session = \Stripe\Checkout\Session::create([
                'payment_method_types' => ['card'],
                'line_items'           => [
                    [
                        'price_data'  => [
                            'product_data' => [
                                'name' => $user->name,
                            ],
                            'unit_amount'  => ($package->amount) * 100,
                            'currency'     => 'USD',
                        ],
                        'quantity'    => 1,
                       
                    ],
                ],
                'mode'                 => 'payment',
                'success_url'          => url('https://api.digixtechsol.com/public/payment-success').'?session_id={CHECKOUT_SESSION_ID}',
                'cancel_url'           => 'https://domyassignments.ai/cancel-payment' ,
            ]);
        $PaymentLogs = new PaymentLogs();
        $PaymentLogs->package_id = $request->package_id;
        $PaymentLogs->user_id = $user->id;
        $PaymentLogs->status = 'unpaid';
        $PaymentLogs->amount = $package->amount;
        $PaymentLogs->session_id = $session->id;
        $PaymentLogs->save();

       
       return $session->url;
          
        }
      

else{
    return false;
}
       

           
    }

    public function successsss(Request $request)
    {
       
        \Stripe\Stripe::setApiKey('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');
        $sessionId = $request->get('session_id');
        try {
         
            $session = \Stripe\Checkout\Session::retrieve($sessionId);
            if (!$session) {
                throw new NotFoundHttpException;
            }

            $PaymentLogs = PaymentLogs::where('session_id', $session->id)->first();
            if (!$PaymentLogs) {
                throw new NotFoundHttpException();
            }
            if ($PaymentLogs->status === 'unpaid') {
                $PaymentLogs->status = 'paid';
                $PaymentLogs->save();

                // $package = Package::where('id', $PaymentLogs->package_id)->first();

                // $package_sub = new UserPackage();
                // $package_sub->user_id= $PaymentLogs->user_id;
                // $package_sub->package_id=  $PaymentLogs->package_id;
                // $package_sub->total_counts=$package->count;
                
                // $package_sub->save();

                $this->packageRepository->register_package($PaymentLogs);
            }

            //return view('product.checkout-success');
           return redirect('https://domyassignments.ai/success');
        } catch (\Exception $e) {
            throw new NotFoundHttpException();
        }

    }

    public function cancel()
    {
        return view('product.checkout-cancel');
    }


    // public function stripePost(Request $request)
    // {
        
    //        try{
    //         $stripe = new \Stripe\StripeClient('pk_test_AT0x9neMvnVTOZkCz6x3dOBk');
    //         $token=$stripe->tokens->create([
    //         'card' => [
    //             'number' => $request->card_number,
    //             'exp_month' =>$request->exp_month,
    //             'exp_year' => $request->exp_year,
    //             'cvc' => $request->cvc,
    //         ],
    //         ]);


    //         Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
    //             // $stripe = new \Stripe\StripeClient('sk_test_AV5na9AOPRuBMHtCJN14dhSS');
    //             $result=Stripe\Charge::create ([
    //                 "amount" =>($request->amount) * 100,
    //                 "currency" => "usd",
    //                 "source" =>$token->id,
    //                 "description" => "" 

    //         ]);
    //                     $data['result']=$result->status;
    //                     $data['amount']=$request->amount;
    //                     $data['card_number']=$request->card_number;

    //                     if($data['result'] == 'succeeded')
    //                     {
    //                         $data['status'] = 'success';
    //                         $data['message'] = 'Payment successful';
    //                     }
    //                     else{
    //                         $data['status'] = 'error';
    //                         $data['message'] = 'Some thing went wrong';

    //                     }
    //                     $user =  auth('sanctum')->user();
                      
    //                     $payment_logs = PaymentLogs::insert([
    //                         'user_id' => $user->id,
    //                         'package_id' => $request->package_id,
    //                         'text' => json_encode($data),
    //                         'created_at' => Date('Y-m-d h:i:s'),
    //                         'updated_at' => Date('Y-m-d h:i:s'),
                           
    //                     ]);
    //                     return response()->json(['status' =>  $data['status'],'message' =>  $data['message']]);;

    //        } 

    //        catch (\Exception $e) {
    //         // Catch any other non-Stripe exceptions
    //         return $e->getMessage();
    //       }
        

           
    // }


}
