<?php

namespace App\Http\Controllers\API;

use App\Models\User;
use App\Models\Website;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;
use Illuminate\Mail\Message; // Add this line
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use App\Mail\CustomResetLinkMail;
use Closure;
use Carbon\Carbon;
use Illuminate\Support\Facades\Config;
use App\Models\SmtpSetting;

class ResetPasswordController extends Controller
{
    public function sendResetLink(Request $request)
    {
        $website = Website::where('domain', $request->domain)->first();
        if (!$website) {
            return response()->json(['status' => 'error', 'message' => 'Domain not found in websites table.'], 404);
        }
    
        $request->validate(['email' => 'required|email']);
        $user = User::where('email', $request->email)
            ->where('website_id', $website->id)
            ->first();
    
        if (!$user) {
            return response()->json(['status' => 'error', 'message' => 'No user found with this email address'], 404);
        }
    
        // Fetch SMTP settings for the website domain
        $smtpSettings = SmtpSetting::where('domain', $website->domain)->first();
        // dd($smtpSettings);
        if ($smtpSettings) {
            Config::set('mail.mailers.smtp.transport', $smtpSettings->mail_mailer);
            Config::set('mail.mailers.smtp.host', $smtpSettings->mail_host);
            Config::set('mail.mailers.smtp.port', $smtpSettings->mail_port);
            Config::set('mail.mailers.smtp.username', $smtpSettings->mail_username);
            Config::set('mail.mailers.smtp.password', $smtpSettings->mail_password);
            Config::set('mail.mailers.smtp.encryption', $smtpSettings->mail_encryption);
            Config::set('mail.from.address', $smtpSettings->mail_from_address);
            Config::set('mail.from.name', $smtpSettings->mail_from_name);
        } else {
            return response()->json(['status' => 'error', 'message' => 'SMTP settings not found for this domain.'], 500);
        }
    
        $response = $this->sendCustomResetLink($user, $website, $smtpSettings);
        return $response == Password::RESET_LINK_SENT
            ? response()->json(['status' => 'success', 'message' => 'Reset link sent to your email.'])
            : response()->json(['status' => 'error', 'message' => 'Something went wrong while sending the email!']);
    }

    protected function sendCustomResetLink(User $user, $website, $smtpSettings)
    {
        $token = app('auth.password.broker')->createToken($user);
        Mail::to($user->email)->send(new CustomResetLinkMail($token, $user->id, $website, $smtpSettings));
        return Password::RESET_LINK_SENT;
    }
    
    public function check_token($token,$id)
    {
        try{
                $token = DB::table('password_reset_tokens') ->where('token','=',$token) ->where('created_at','>',Carbon::now()->subHours(2))->first();
                $user = User::find($id);
                return response()->json(['status'=>'success','data'=>$user]);
        }catch(\Exception $e){
              return response()->json(['status'=>'success','data'=>$e->getMessage()]);
        }
    }
}
