<?php
namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Interfaces\StripeSubscriptionRepositoryInterface;
use DB;
use Illuminate\Support\Facades\Http;

class StripeSubscriptionController extends Controller
{
    private StripeSubscriptionRepositoryInterface $stripeSubscriptionRepositoryInterface;
    public function __construct(StripeSubscriptionRepositoryInterface $stripeSubscriptionRepositoryInterface)
    {
        $this->stripeSubscriptionRepositoryInterface = $stripeSubscriptionRepositoryInterface;
    }
    public function plans(Request $request)
    {
        return $this->stripeSubscriptionRepositoryInterface->stripe_plans($request);
    }
    public function show(Request $request, $plan)
    {
        return $this->stripeSubscriptionRepositoryInterface->show($request, $plan);
    }
    public function subscription(Request $request)
    {
        return $this->stripeSubscriptionRepositoryInterface->subscription($request);
    }
    public function user_subscriptions()
    {
       return $this->stripeSubscriptionRepositoryInterface->user_subscriptions();
    }
    public function default(Request $request)
    {
        return $this->stripeSubscriptionRepositoryInterface->default_subscription($request);
    }
    public function add_credits(Request $request){
        return $this->stripeSubscriptionRepositoryInterface->add_credits($request);
    }
    public function cancel_subscriptions(Request $request)
    {
        return $this->stripeSubscriptionRepositoryInterface->cancel_subscriptions($request);
    }
    public function resum_subscriptions(Request $request)
    {
       return $this->stripeSubscriptionRepositoryInterface->resum_subscriptions($request);
    }
    public function add_new_card(Request $request)
    {
       return $this->stripeSubscriptionRepositoryInterface->add_new_card($request);
    }
    public function client_order(Request $request){
       return $this->stripeSubscriptionRepositoryInterface->client_order_add($request);
    }
    
     public function generatelogoai(Request $request){
        return $this->stripeSubscriptionRepositoryInterface->generatelogo($request);
      
     }
     
     public function getCharacter()
     {
         
        $characters = DB::table('icons')->get();
        $icons = url('/images/icons');
        $imagepath = url('/images/preview');
        return response()->json(['icons' => $characters ,'icon_path' => $icons,'image_path' => $imagepath], 200);

     }
     public function getSvg(Request $request)
{
 $validator = Validator::make($request->all(), [
                        'text' => 'required|string|max:1000',
                        'pages_words' => 'required',
                        'style' => 'required'
                    ]);
    $svgIDs = $request->svg_id;
    // $idCount = count($svgIDs);
    // $url = [];

    // $combinations = [];
    // if ($idCount == 1) {
    //     // For 1 ID, repeat it 5 times
    //     $combinations = array_fill(0, 5, $svgIDs);
    // } elseif ($idCount == 2) {
    //     $combinations = [
    //         [$svgIDs[0], $svgIDs[1]], // First group with both IDs
    //         [$svgIDs[0], $svgIDs[1]], // Second group with both IDs
    //         [$svgIDs[0]] // Single ID group
    //     ];
    // } elseif ($idCount == 3) {
    //     $combinations = [
    //         array_slice($svgIDs, 0, 2),
    //         array_slice($svgIDs, 1, 2),
    //         array_slice($svgIDs, 0, 1)
    //     ];
    // } elseif ($idCount == 4) {
    //     // For 4 IDs, create five groups of 1 ID each
    //     $combinations = [
    //         [$svgIDs[0]],
    //         [$svgIDs[1]],
    //         [$svgIDs[2]],
    //         [$svgIDs[3]],
    //         [$svgIDs[0]] // Repeating one ID to ensure 5 groups
    //     ];
    // } else {
    //     // For other counts (e.g., 5 or more), create a single group with all IDs
    //     $combinations = [$svgIDs];
    // }

    // $idss = [];
    // if ($idCount < 5) {
    //     foreach ($combinations as $combination) {
    //         foreach ($combination as $id) {
    //             $characters = DB::table('icons')->where('icon_id', $id)->first();
    //             if ($characters) {
    //                 $iconUrl = 'https://staggingdigiwiser.website/ai_project/dissertation_api/public/images/icons/' . $characters->icon_url;
    //               $idss[] = $characters->icon_id;
    //                 $url[] = file_get_contents($iconUrl, FILE_USE_INCLUDE_PATH);
    //             }
    //         }
    //     }
    // }
    //  else {
        foreach($svgIDs as $id)
        {
            $characters = DB::table('icons')->where('icon_id',$id)->first();
            $idss[] = $characters->icon_id;
            $url[] =  file_get_contents('https://staggingdigiwiser.website/ai_project/dissertation_api/public/images/icons/' . $characters->icon_url,FILE_USE_INCLUDE_PATH);
    
        }
    // }

    
    
        return response()->json(['icons' => $url,'icon_id' => $idss], 200);
}
}
