<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckUserDissertationExists
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user_package = auth('sanctum')->user();
        if ($user_package) {
            $user_packages = $user_package;
            if ($user_packages->user_total_hits) {
                if ($user_packages->user_total_hits && $user_packages->user_total_hits->dissertation >= 1) {
                    return $next($request);
                } else {
                    return response(['status' => 'error', 'text' => 'No Hits Found!'], 409);
                }
            } else {
                return response(['status' => 'error', 'text' => 'No Dssertation Found!'], 404);
            }
        } else {
            return response(['status' => 'error', 'text' => 'User Not Found!'], 404);
        }
    }
}
