<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\GenerateTextRepositoryInterface;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\UserTrait;
use App\Http\Traits\GenerateTrait;
use App\Models\Dissertation;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use App\Models\Generate;
use App\Models\Website;
use App\Models\UserPackage;
use App\Models\PackageCounts;
use App\Models\Documents;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use App\Models\AiLogos;
use App\Http\Repositories\Log;
use App\Models\UserDownloads;
use Laravel\Sanctum\PersonalAccessToken;

class GenerateTextRepository implements GenerateTextRepositoryInterface
{
    use  UserTrait, GenerateTrait;
    public $check_auth;

    public function __construct()
    {
        $this->check_auth = $this->check_auth();
    }

    // public function history_generator($request)
    // {
    //         try{
    //             $packages = [];
    //             if($this->check_auth['user']->user_packages){
    //                 $data['status'] = "success";
    //                 foreach($this->check_auth['user']->user_packages as $key=>$value){
    //                     $packages[] = $value->id; 
    //                 }
    //                 $packages_data_ = Generate::whereIn('generate.user_package_id', $packages);
    //                 $packages_datas = Dissertation::whereIn('dissertation.user_package_id', $packages)->orWhere('user_id',$this->check_auth['user']->id)->get();   
    //             }else{
    //                 $packages_datas = "Package not found!";
    //             }
    //             $data['status'] = "success";
    //             $data['text'] = $packages_datas;
    //             return response()->json($data,200);
    //         }catch(\Exception $e){
    //               $data['status'] = "error";
    //               $data['text'] = $e->getMessage();
    //                  return response()->json($data,500);
    //         }
      
       
    // }
    
    public function history_generator($request)
    {
        try {
            $packages = [];
            $data = [];
    
            // Check if the user has packages
            if ($this->check_auth['user']->user_packages) {
                $data['status'] = "success";
    
                // Extract package IDs
                foreach ($this->check_auth['user']->user_packages as $value) {
                    $packages[] = $value->id;
                }
    
                // Fetch relevant data
                $packages_data_ = Generate::whereIn('generate.user_package_id', $packages)->get();
                $packages_datas = Dissertation::whereIn('dissertation.user_package_id', $packages)
                    ->orWhere('user_id', $this->check_auth['user']->id)
                    ->get();
    
                // Prepare response
                $data['status'] = "success";
                $data['text'] = [
                    'current_page' => $request->input('page', 1),
                    'data' => $packages_datas,
                    'first_page_url' => url("/api/history?page=1"),
                    'last_page' => ceil($packages_datas->count() / 100),
                    'last_page_url' => url("/api/history?page=" . ceil($packages_datas->count() / 100)),
                    'next_page_url' => $request->input('page', 1) < ceil($packages_datas->count() / 100) 
                        ? url("/api/history?page=" . ($request->input('page', 1) + 1))
                        : null,
                    'prev_page_url' => $request->input('page', 1) > 1 
                        ? url("/api/history?page=" . ($request->input('page', 1) - 1))
                        : null,
                    'path' => url("/api/history"),
                    'per_page' => 100,
                    'from' => 1,
                    'to' => $packages_datas->count(),
                    'total' => $packages_datas->count()
                ];
    
            } else {
                // Handle case where no packages are found
                $data['status'] = "error";
                $data['message'] = "Package not found!";
            }
    
            return response()->json($data);
        } catch (Exception $e) {
            // Handle exceptions
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage(),
            ], 500);
        }
    }


    public function final_question($request)
    {
        $text = "";
        if ($request->type == 'topic') {
            $text .= "Suggest 15 dissertation topics for {$request->assigmentBrief}, and the subject area is {$request->SubjectArea}.";
        } else {
            $text .= "Generate text on : {$request->text} of {$request->pages_words} words and add list of {$request->style} reference at the end.";
        }
        return $text;
    }

    public function file__name($text)
    {
        $file_name = "";

        foreach (explode(' ', $text) as $key => $value) {
            if ($key <= 10) {
                if ($value != 'docx') {
                    $file_name .= $value . '.';
                }
            }
        }
        return implode(" ", explode('.', $file_name));
    }
    public function upload_documents($request)
    {
        try {
            $status_code = 404;
            $data['status'] = "error";
            $data['generation_id'] = "";
            $data['file'] = "";
            $data['message'] = "";
            return  DB::transaction(function () use ($request, $data, $status_code) {
                $validator = Validator::make($request->all(), [
                    'file' => 'required|mimes:doc,docx',
                    'generation_id' => 'integer|required',
                ]);
                if ($validator->fails()) {
                    $status_code = 400;
                    $error_message = $validator->messages();
                    if ($error_message->first('generation_id')) {
                        $data['generation_id'] = $error_message->first('generation_id');
                    } else {
                        $data['generation_id'] = $request->generation_id;
                    }
                    if ($error_message->first('file')) {
                        $data['file'] = $error_message->first('file');
                    } else {
                        $data['file'] = $request->text;
                    }
                    $data['message'] = $error_message;
                    return response()->json($data, $status_code);
                }
                $documents = new Documents();
                $datetime = date('YmdHis') . $request->generation_id;
                $documents->generated_id = $request->generation_id;
                $ext = $request->file->getClientOriginalExtension();
                $name = trim($this->file__name($request->file->getClientOriginalName())) . '.' . $ext;
                $path = $request->file('file')->storeAs('files/documents/' . $datetime, $name, 'public');
                $documents->documents = $path;
                $documents->save();
                $data['status'] = "success";
                $data['generation_id'] = "";
                $data['file'] = "";
                $data['message'] = "";
                return response()->json($data, $status_code);
            });
        } catch (\Exception $e) {
            $status_code = 500;
            $data['status'] = "error";
            $data['generation_id'] = "";
            $data['file'] = "";
            $data['message'] = $e->getMessage();
            return response()->json($data, $status_code);
        }
    }
public function generateText($request)
{
    try {
        $status_code = 404;
        $response = $this->prepareResponse("error");
        return DB::transaction(function () use ($request, $response, &$status_code) {
            // Check if the user is authorized
            if ($this->check_auth['status'] !== 'success') {
                $response = $this->prepareResponse($this->check_auth['status'], $this->check_auth['message']);
                return response()->json($response, $status_code);
            }

            // Validate incoming request
            $validator = Validator::make($request->all(), [
                'text' => 'required|string|max:1000',
                // 'pages_words' => 'required|integer|min:1',
                'style' => 'required|string'
            ]);

            if ($validator->fails()) {
                $status_code = 400;
                $response = $this->processValidation($validator, $request);
                return response()->json($response, $status_code);
            }

            // Create a new Generate entry
            $generate = new Generate();
            $user_package_id = $this->getValidUserPackage();

            // Check if the user has a valid package
            if (!$user_package_id) {
                $response['text'] = "No valid user package available.";
                return response()->json($response, $status_code);
            }

            // Save Generate entry
            $generate->user_package_id = $user_package_id;
            $generate->text = $this->finalizeText($request);
            $generate->inputs = json_encode($request->all());
            $generate->save();

            // Decrement the counts in the related tables
            $this->decrementUserPackageCount($generate->user_package_id);
            
            // Prepare the response with success status and output
            $status_code = 200;
            $response = $this->prepareResponse(
                "success",
                $generate->text,
                $this->createOutput($generate),
                [
                    'request' => $request->type === 'topic' ? $request->assignmentBrief : $request->text,
                    'pages_words' => $request->pages_words,
                    'style' => $request->style,
                    'id' => $generate->id
                ]
            );

            return response()->json($response, $status_code);
        });
    } catch (\Exception $e) {
        // Return error response if something goes wrong
        $response = $this->prepareResponse("error", $e->getMessage());
        return response()->json($response, 500);
    }
}

private function prepareResponse($status, $text = "", $output = "", $additional = [])
{
    return array_merge([
        'status' => $status,
        'text' => $text,
        'output' => $output
    ], $additional);
}

private function processValidation($validator, $request)
{
    $response = $this->prepareResponse("error");

    // Collect validation errors for the specific fields
    foreach (['text', 'pages_words', 'style'] as $field) {
        $response[$field] = $validator->messages()->first($field) ?? $request->$field;
    }

    return $response;
}

private function getValidUserPackage()
{
    // Loop through user packages and return the valid one
    foreach ($this->check_auth['user']->user_packages as $package) {
        if ($package->total_counts >= 1) {
            return $package->id;
        }
    }
    return null;
}

public function createOutput($generate)
{
    $output = "";
    $save = Generate::find($generate->id);
    $inputs = json_decode($generate->inputs);

    if ($inputs->pages_words >= 1000) {
        // If pages_words >= 1000, generate overview and detailed output
        $overview = $this->generateOutputResult($this->buildAIRequest('overview', $inputs->text, $inputs->pages_words));
        $details = $this->generateOutputResult($this->buildAIRequest('detailed', $inputs->text, $inputs->pages_words, $inputs->style));
        $output = $overview . '<br>' . $details;
    } else {
        // Otherwise, generate output for the text
        $output = $this->generateOutputResult($save->text);
    }

    $save->text = $generate->text;
    $save->output = $output;
    $save->save();

    return $output;
}

private function buildAIRequest($type, $text, $pages_words, $style = null)
{
    // Build AI request for overview or detailed request
    if ($type === 'overview') {
        return "Generate an overview of {$text} of {$pages_words} words.";
    }
    if ($type === 'detailed') {
        return "Elaborate in detail about the topic {$text} of {$pages_words} words and add a list of {$style} references at the end.";
    }
    return $text;
}

public function generateOutputResult($text)
{
    // Call OpenAI API to generate output based on the provided text
    $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . 'sk-proj-Dei7vrqW9271yUxIUsOHT3BlbkFJaLn5FCynyAMTyV7pFwJE',
        ])->post('https://api.openai.com/v1/chat/completions', [
            'model' => "gpt-3.5-turbo",
        'messages' => [
            ['role' => 'user', 'content' => $text]
        ],
        'temperature' => 0.7,
        'max_tokens' => 1000,
        'top_p' => 1.0,
        'frequency_penalty' => 0.5,
        'presence_penalty' => 0.5,
    ]);

    // Check if the OpenAI request failed
    if ($response->failed()) {
        return "Error generating output.";
    }

    // Return generated content from the OpenAI response
    $responseData = $response->json();
    return $responseData['choices'][0]['message']['content'] ?? "Invalid response.";
}

private function finalizeText($request)
{
    // Finalize and return the text from the request
    return $request->text;
}

private function decrementUserPackageCount($user_package_id)
{
    // Decrement the count by 1 for the user_package and package_counts table
    $userPackage = UserPackage::find($user_package_id);
    // dd($userPackage);
    if ($userPackage) {
        $userPackage->total_counts -= 1; // Decrement by 1
        $userPackage->save();
    }

    // Decrement package_counts if necessary
    $packageCount = PackageCounts::where('user_id', $userPackage->user_id)->first();
    // dd($packageCount);
    if ($packageCount) {
        $packageCount->total_counts -= 1; // Decrement by 1
        $packageCount->save();
    }

    // Increment total_counts back by 2
    if ($userPackage) {
        $userPackage->total_counts += 2; // Add 2
        $userPackage->save();
    }

    if ($packageCount) {
        $packageCount->total_counts += 3; // Add 2
        $packageCount->save();
    }
}
    
    // public function generateText($request)
    // {
    //     try {
    //         $status_code = 404;
    //         $data = [
    //             'request' => "",
    //             'text' => "",
    //             'pages_words' => "",
    //             'style' => "",
    //             'status' => "error",
    //             'output' => "",
    //             'id' => ""
    //         ];
    
    //         return DB::transaction(function () use ($request, $data, $status_code) {
    //             if ($this->check_auth['status'] == 'success') {
    //                 $validator = Validator::make($request->all(), [
    //                     'text' => 'required|string|max:1000',
    //                     'pages_words' => 'required',
    //                     'style' => 'required'
    //                 ]);
    
    //                 if ($validator->fails()) {
    //                     $status_code = 400;
    //                     $error_message = $validator->messages();
    //                     $data['text'] = $error_message->first('text') ?? $request->text ?? "";
    //                     $data['pages_words'] = $error_message->first('pages_words') ?? $request->pages_words ?? "";
    //                     $data['style'] = $error_message->first('style') ?? $request->style ?? "";
    //                     return response()->json($data, $status_code);
    //                 }
    
    //                 $generate = new Generate();
    //                 $generate->user_package_id = $this->getUserPackageId($this->check_auth['user']->user_packages);
    //                 $generate->text = $this->final_question($request);
    //                 $generate->inputs = json_encode($request->all());
    //                 $generate->save();
    
    //                 $data['status'] = "success";
    //                 $data['request'] = $request->type == 'topic' ? $request->assigmentBrief : $request->text;
    //                 $data['text'] = $generate->text;
    //                 $data['output'] = $generate->text; // Use text directly
    //                 $data['pages_words'] = $request->pages_words;
    //                 $data['style'] = $request->style;
    //                 $data['id'] = $generate->id;
    
    //                 return response()->json($data, 200);
    //             } else {
    //                 $data['status'] = $this->check_auth['status'];
    //                 $data['text'] = $this->check_auth['message'];
    //                 return response()->json($data, $status_code);
    //             }
    //         });
    //     } catch (\Exception $e) {
    //         $data['status'] = "error";
    //         $data['text'] = $e->getMessage();
    //         return response()->json($data, 500);
    //     }
    // }
    
    // private function getUserPackageId($userPackages)
    // {
    //     foreach ($userPackages as $package) {
    //         if ($package->total_counts >= 1) {
    //             return $package->id;
    //         }
    //     }
    //     return null;
    // }
    // public function generate_dissertation($request)
    // {

    //     try {
    //         $status_code = 404;

    //         $data['topic'] = "";
    //         $data['type'] = "";
    //         $data['totalWordCount'] = "";
    //         $data['methodology'] = "";
    //         $data['educationLevel'] = "";
    //         $data['disciplineMajors'] = "";
    //         $data['status'] = "error";
    //         $data['output'] = "";
    //         $data['id'] = "";
    //           $data['request'] =  "";
    //         return  DB::transaction(function () use ($request, $data, $status_code) {
    //             if ($this->check_auth['status'] == 'success') {
    //                 $validator = Validator::make($request->all(), [
    //                     'topic' => 'required|string|max:1000',
    //                     'totalWordCount' => 'required',
    //                     'methodology' => 'required',
    //                     'educationLevel' => 'required',
    //                     'disciplineMajors' => 'required',
    //                 ]);
    //                 if ($validator->fails()) {
    //                     $status_code = 400;
    //                     $error_message = $validator->messages();
    //                     if ($error_message->first('text')) {
    //                         $data['topic'] = $error_message->first('topic');
    //                     } else {
    //                         $data['topic'] = $request->topic;
    //                     }
    //                     if ($error_message->first('totalWordCount')) {
    //                         $data['totalWordCount'] = $error_message->first('totalWordCount');
    //                     } else {
    //                         $data['totalWordCount'] = $request->totalWordCount;
    //                     }
    //                     if ($error_message->first('methodology')) {
    //                         $data['methodology'] = $error_message->first('methodology');
    //                     } else {
    //                         $data['methodology'] = $request->methodology;
    //                     }

    //                     if ($error_message->first('educationLevel')) {
    //                         $data['educationLevel'] = $error_message->first('educationLevel');
    //                     } else {
    //                         $data['educationLevel'] = $request->educationLevel;
    //                     }
    //                     if ($error_message->first('disciplineMajors')) {
    //                         $data['disciplineMajors'] = $error_message->first('disciplineMajors');
    //                     } else {
    //                         $data['disciplineMajors'] = $request->disciplineMajors;
    //                     }
    //                     return response()->json($data, $status_code);
    //                 }

    //                 $generate = new Dissertation();
    //                 $user_package_ids = "";


    //                 foreach ($this->check_auth['user']->user_packages as $key => $value) {
    //                     if ($value->dissertation >= 1) {
    //                         $user_package_ids = $value->id;
    //                         break;
    //                     }
    //                 }
                    
    //                 $generate->user_package_id =  $user_package_ids;
    //                 // $generate->text =  $this->generate_dessertions($request);
    //                 $generate->text = json_encode($this->generate_dessertions($request));
    //                 $generate->save();
    //                 $data['output'] = Dissertation::find($generate->id)->output;
    //                 $data['id'] = $generate->id;
    //                 $data['status'] = "success";
    //                 $data['request'] = $request->topic;
    //                 $data['topic'] = $request->topic;
    //                 $data['totalWordCount'] = "";
    //                 $data['methodology'] = "";
    //                 $data['educationLevel'] = "";
    //                 $data['disciplineMajors'] = "";
    //                 return response()->json($data, 200);
    //             } else {

    //                 return response()->json($data, $status_code);
    //             }
    //         });
    //     } catch (\Exception $e) {
    //         $data['request'] =  "";
    //         $data['topic'] =  "";
    //         $data['status'] = "error";
    //          $data['output'] = $e->getMessage();
    //         $data['totalWordCount'] = "";
    //         $data['methodology'] = "";
    //         $data['educationLevel'] = "";
    //         $data['disciplineMajors'] = "";
    //         return response()->json($data, 500);
    //     }
    // }
    
//     public function generate_dissertation($request)
// {
//     try {
//         $status_code = 404;

//         $data = [
//             'topic' => "",
//             'type' => "",
//             'totalWordCount' => "",
//             'methodology' => "",
//             'educationLevel' => "",
//             'disciplineMajors' => "",
//             'status' => "error",
//             'output' => "",
//             'id' => "",
//             'request' => "",
//         ];

//         return DB::transaction(function () use ($request, $data, $status_code) {
//             // Check authentication status
//             if ($this->check_auth['status'] == 'success') {
//                 // Validate request data
//                 $validator = Validator::make($request->all(), [
//                     'topic' => 'required|string|max:1000',
//                     'totalWordCount' => 'required|integer',
//                     'methodology' => 'required|string',
//                     'educationLevel' => 'required|string',
//                     'disciplineMajors' => 'required|string',
//                 ]);

//                 if ($validator->fails()) {
//                     $status_code = 400;
//                     foreach (['topic', 'totalWordCount', 'methodology', 'educationLevel', 'disciplineMajors'] as $field) {
//                         $data[$field] = $validator->errors()->first($field) ?: $request->{$field};
//                     }
//                     return response()->json($data, $status_code);
//                 }

//                 // Check user packages for dissertation availability
//                 $user_package_ids = null;
//                 foreach ($this->check_auth['user']->user_packages as $package) {
//                     if ($package->dissertation >= 1) {
//                         $user_package_ids = $package->id;
//                         break;
//                     }
//                 }

//                 if (!$user_package_ids) {
//                     return response()->json(['status' => 'error', 'message' => 'No valid package found.'], 403);
//                 }

//                 // Generate dissertation using OpenAI API
//                 $generatedText = $this->generateDissertationOutputResult($request->topic);

//                 if (empty($generatedText)) {
//                     return response()->json(['status' => 'error', 'message' => 'Failed to generate dissertation.'], 500);
//                 }

//                 // Save dissertation to the database
//                 $dissertation = new Dissertation();
//                 $dissertation->user_package_id = $user_package_ids;
//                 $dissertation->text = $generatedText;
//                 $dissertation->save();

//                 // Populate response data
//                 $data['output'] = $generatedText;
//                 $data['id'] = $dissertation->id;
//                 $data['status'] = "success";
//                 $data['request'] = $request->topic;
//                 $data['topic'] = $request->topic;

//                 return response()->json($data, 200);
//             } else {
//                 return response()->json($data, $status_code);
//             }
//         });
//     } catch (\Exception $e) {
//         // Handle unexpected exceptions
//         $data['status'] = "error";
//         $data['output'] = $e->getMessage();
//         return response()->json($data, 500);
//     }
// }

public function generate_dissertation($request)
{
    // try {
        $status_code = 404;

        $data = [
            'topic' => "",
            'type' => "",
            'totalWordCount' => "",
            'methodology' => "",
            'educationLevel' => "",
            'disciplineMajors' => "",
            'status' => "error",
            'output' => "",
            'id' => "",
            'request' => "",
        ];

        return DB::transaction(function () use ($request, $data, $status_code) {
            // Check authentication status
            if ($this->check_auth['status'] == 'success') {
                // Validate request data
                $validator = Validator::make($request->all(), [
                    'topic' => 'required|string|max:1000',
                    'totalWordCount' => 'required|integer',
                    'methodology' => 'required|string',
                    'educationLevel' => 'required|string',
                    'disciplineMajors' => 'required|string',
                ]);

                if ($validator->fails()) {
                    $status_code = 400;
                    foreach (['topic', 'totalWordCount', 'methodology', 'educationLevel', 'disciplineMajors'] as $field) {
                        $data[$field] = $validator->errors()->first($field) ?: $request->{$field};
                    }
                    return response()->json($data, $status_code);
                }

                // Check user packages for dissertation availability
                $user_package_ids = null;
                foreach ($this->check_auth['user']->user_packages as $package) {
                    if ($package->dissertation >= 1) {
                        $user_package_ids = $package->id;
                        break;
                    }
                }

                if (!$user_package_ids) {
                    return response()->json(['status' => 'error', 'message' => 'No valid package found.'], 403);
                }

                // Prepare input for generating dissertation
                $input = [
                    'topic' => $request->topic,
                    'totalWordCount' => $request->totalWordCount,
                    'methodology' => $request->methodology,
                    'educationLevel' => $request->educationLevel,
                ];

                // Generate dissertation using OpenAI API
                $generatedText = $this->generateDissertationOutputResult($input);

                if (empty($generatedText)) {
                    return response()->json(['status' => 'error', 'message' => 'Failed to generate dissertation.'], 500);
                }

                // Save dissertation to the database
                $dissertation = new Dissertation();
                $dissertation->user_package_id = $user_package_ids;
                $dissertation->text = $generatedText;
                $dissertation->save();

                // Populate response data
                $data['output'] = $generatedText;
                $data['text'] = $generatedText;
                $data['id'] = $dissertation->id;
                $data['status'] = "success";
                $data['request'] = $request->topic;
                $data['topic'] = $request->topic;
                $data['totalWordCount'] = $request->totalWordCount;
                $data['methodology'] = $request->methodology;
                $data['educationLevel'] = $request->educationLevel;

                return response()->json($data, 200);
            } else {
                return response()->json($data, $status_code);
            }
        });
    // } catch (\Exception $e) {
    //     // Handle unexpected exceptions
    //     $data['status'] = "error";
    //     $data['output'] = $e->getMessage();
    //     return response()->json($data, 500);
    // }
}

public function generateDissertationOutputResult($input)
{
    try {
        $sections = [
            ["title" => "Introduction", "min_words" => 400],
            ["title" => "Literature Review", "min_words" => 800],
            ["title" => "Methodology", "min_words" => 600],
            ["title" => "Results and Discussion", "min_words" => 800],
            ["title" => "Conclusion", "min_words" => 400],
        ];

        $generatedContent = "";
        $currentWordCount = 0;

        foreach ($sections as $section) {
            $prompt = "Generate the {$section['title']} section of a PhD dissertation based on the following details:\n" .
                      "Topic: {$input['topic']}\n" .
                      "Total Word Count: {$section['min_words']} words\n" .
                      "Methodology: {$input['methodology']}\n" .
                      "Education Level: {$input['educationLevel']} (PhD level)\n" .
                      "The output must use academic language, include critical analysis, and provide detailed arguments for the {$section['title']} section.\n";

            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . 'sk-proj-Dei7vrqW9271yUxIUsOHT3BlbkFJaLn5FCynyAMTyV7pFwJE',
            ])->post('https://api.openai.com/v1/chat/completions', [
                'model' => "gpt-3.5-turbo",
                'messages' => [
                    ['role' => 'user', 'content' => $prompt]
                ],
                'temperature' => 0.7,
                'max_tokens' => 2048,
                'top_p' => 1.0,
                'frequency_penalty' => 0.5,
                'presence_penalty' => 0.5,
            ]);

            if ($response->failed()) {
                return null;
                
            }

            $responseData = $response->json();
            $sectionContent = $responseData['choices'][0]['message']['content'] ?? null;

            if ($sectionContent) {
                $currentWordCount += str_word_count($sectionContent);
                $generatedContent .= "\n\n" . $sectionContent; // Removed extra headings
            }

            // If the total word count exceeds or meets the requirement, stop further generation
            if ($currentWordCount >= $input['totalWordCount']) {
                break;
            }
        }

        // Final validation of total word count
        if ($currentWordCount < $input['totalWordCount']) {
            $remainingWords = $input['totalWordCount'] - $currentWordCount;
            $prompt = "Expand the dissertation with additional critical analysis to meet the total word count requirement of {$remainingWords} words. Ensure the content aligns with the PhD level of education.";
            
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . 'sk-proj-Dei7vrqW9271yUxIUsOHT3BlbkFJaLn5FCynyAMTyV7pFwJE',
            ])->post('https://api.openai.com/v1/chat/completions', [
                'model' => "gpt-3.5-turbo",
                'messages' => [
                    ['role' => 'user', 'content' => $prompt]
                ],
                'temperature' => 0.7,
                'max_tokens' => 2048,
                'top_p' => 1.0,
                'frequency_penalty' => 0.5,
                'presence_penalty' => 0.5,
            ]);

            if (!$response->failed()) {
                $extraContent = $response->json()['choices'][0]['message']['content'] ?? null;
                $generatedContent .= "\n\n" . $extraContent; // Added directly without extra headings
            }
        }

        return $generatedContent;
    } catch (\Exception $e) {
        return null;
    }
}



    public function theisesssss($request){
        
    } 
    public function theises($request)
    {
        
        try {
            $status_code = 404;
            $data['request'] = "";
            $data['text'] = "";
            $data['pages_words'] = "";
            $data['style'] = "";
            $data['status'] = "error";
            $data['output'] = "";
            $data['id'] = "";
            return  DB::transaction(function () use ($request, $data, $status_code) {
                if ($this->check_auth['status'] == 'success') {
                    // $validator = Validator::make($request->all(), [
                    //     'text' => 'required|string|max:1000',
                    //     'pages_words' => 'required',
                    //     'style' => 'required'
                    // ]);
                    // if ($validator->fails()) {
                    //     $status_code = 400;
                    //     $error_message = $validator->messages();
                    //     if ($error_message->first('text')) {
                    //         $data['text'] = $error_message->first('text');
                    //     } else {
                    //         $data['text'] = $request->text;
                    //     }
                    //     if ($error_message->first('pages_words')) {
                    //         $data['pages_words'] = $error_message->first('pages_words');
                    //     } else {
                    //         $data['pages_words'] = $request->text;
                    //     }
                    //     if ($error_message->first('style')) {
                    //         $data['style'] = $error_message->first('style');
                    //     } else {
                    //         $data['style'] = $request->text;
                    //     }
                    //     return response()->json($data, $status_code);
                    // }
                    // $generate = new Generate();
                    // $user_package_ids = "";
                    // foreach ($this->check_auth['user']->user_packages as $key => $value) {
                    //     if ($value->total_counts >= 1) {
                    //         $user_package_ids = $value->id;
                    //         break;
                    //     }
                    // }
                
                     $output = "";
                    $final_question = "Suggest 15 dissertation topics for {$request->assigmentBrief}, and the subject area is {$request->SubjectArea}.";
                        $details       = $this->getOutPutResulttheises( $final_question);
                    
                       $generate = DB::table('dissertation')->insert(
                                ['user_id' => $this->check_auth['user']->id, 'text' =>$final_question , 'inputs' =>  json_encode($request->all()),'output'=>$details,'created_at'=>date('Y-m-d H:i:s'),'updated_at'=>date('Y-m-d H:i:s')]
                        );
                    
                    $data['status'] = "success";
                    if ($request->type == 'topic') {
                        $data['request'] = $request->assigmentBrief;
                    } else {
                        $data['request'] = $request->text;
                    }
                    // return $details , $final_question;
                    $data['text'] =  $final_question;
                    $data['output'] = $details;
               
  
               
                    return response()->json($data, 200);
                } else {
                    $data['status'] = $this->check_auth['status'];
                    $data['status'] = $this->check_auth['status'];
                    $data['text'] = $this->check_auth['message'];
                    $data['output'] = "";
                    $data['pages_words'] = "";
                    $data['style'] = "";
                    $data['id'] = "";

                    return response()->json($data, $status_code);
                }
            });
        } catch (\Exception $e) {
            $data['request'] =  "";
            $data['status'] = "error";
            $data['text'] = $e->getMessage();
            $data['output'] = "";
            $data['pages_words'] = "";
            $data['style'] = "";
            return response()->json($data, 500);
        }
    }
    
     private function downloadAndSaveImage($imageUrl)
    {
        $response = Http::get($imageUrl);
        if ($response->successful()) {
            // Define the path and filename where you want to save the image
            $randomString = Str::random(20);

            // Extract the file extension from the URL
            $extension = pathinfo(parse_url($imageUrl, PHP_URL_PATH), PATHINFO_EXTENSION);

            // Create the filename with random string and extension
            $fileName = $randomString . '.' . $extension;
    

            // Define the path where you want to save the image
            $publicPath = public_path('images/' . $fileName);

            // Ensure the directory exists
            File::ensureDirectoryExists(public_path('images'));

            // Save the image to the specified path
            File::put($publicPath, $response->body());
            return $fileName;
        } else {
            return 'Failed to retrieve image. Status code: ' . $response->status();
        }
    }
     private function changeTOBase64($logos)
    {
        $baseimage = [];
        foreach($logos as $datas)
        {
            $imagePath = url('/images/' . $datas->image_name);

            $imageContent = file_get_contents($imagePath);

            // Encode the image content to Base64
            $baseimage[] =
            [
                'image' =>  'data:image/png;base64,'.base64_encode($imageContent),
                'id' => $datas->id
                
                ];
            
    
        }
        return $baseimage;
        
        
    }
    public function generatelogo($request)
    {
        // dd($request->all());
        try {
            $status_code = 404;
            $data['status'] = "error";
            $data['output'] = [];
            $data['id'] = "";
            return  DB::transaction(function () use ($request, $data, $status_code) {
                if ($this->check_auth['status'] == 'success') {
                    $validator = Validator::make($request->all(), [
                        'prompt' => 'required|string',
                        // 'domain' => 'required|string',

                    ]);
                    if ($validator->fails()) {
                        $status_code = 400;
                        $error_message = $validator->messages();
                        if ($error_message->first('prompt')) {
                            $data['prompt'] = $error_message->first('prompt');
                        } else {
                            $data['topic'] = $request->topic;
                        }
                        return response()->json($data, $status_code);
                    }
                    $website = Website::where('domain', $request->domain)->first();
                    if (!$website) {
                        $data['error'] = "Domain not found in websites table.";
                        return response()->json($data, 404);
                    }
                    // dd($website);

                    $generate = new Dissertation();
                    $user_package_ids = "";
                    foreach ($this->check_auth['user']->user_packages as $key => $value) {
                        if ($value->dissertation >= 1) {
                            $user_package_ids = $value->id;
                            break;
                        }
                    }
                   // $url = $this->generate_dessertions($request);
                    // $downloaded_file = [];
                    // foreach($url as $ur)
                    // {
                    //     $cleanurl = str_replace('<br>', '', $ur);
                    //     $downloaded_file[] = $this->downloadAndSaveImage($cleanurl);
                    // }
                    // $generate->output = json_encode($url);
                    // $generate->image_name = json_encode($downloaded_file);
                    $generate->user_package_id =  $user_package_ids;
                    $generate->text =  $request->prompt;
                    $generate->website_id =  $website->id;
                    $generate->inputs =  json_encode($request->all());
                    $generate->user_id =   auth('sanctum')->user()->id;
                    $generate->save();    
                    $data['output']= Dissertation::find($generate->id)->output; 
                    $data['output'] =json_decode($data['output']);
                    $data['id'] = $generate->id;
                    $logos = AiLogos::where('dissertation_id',$generate->id)->get();
                    $base6 = $this->changeTOBase64($logos);
                    $data['status'] = "success";
                    $imagepath = url('/images');
                    // return response()->json($data, 200);
                    return response()->json(['data' => $data,'images' => $logos, 'image_path' => $imagepath,'base6' => $base6], 200);
                } else {

                    return response()->json($data, $status_code);
                }
            });
        } catch (\Exception $e) {
            $data['request'] =  "";
            $data['topic'] =  "";
            $data['status'] = "error";
             $data['output'] = $e->getMessage();
            return response()->json($data, 500);
        }
    }
    
    public function generatesvg($request)
   {
                   $data['svg'] = "";

                 $validator = Validator::make($request->all(), [
                        'svg_id' => 'required',
                    ]);
                     if ($validator->fails()) {
                        $status_code = 400;
                        $error_message = $validator->messages();
                        return response()->json($error_message);
                    }
    $svgIDs = $request->svg_id;
    // $idCount = count($svgIDs);
    // $url = [];

    // $combinations = [];
    // if ($idCount == 1) {
    //     // For 1 ID, repeat it 5 times
    //     $combinations = array_fill(0, 5, $svgIDs);
    // } elseif ($idCount == 2) {
    //     $combinations = [
    //         [$svgIDs[0], $svgIDs[1]], // First group with both IDs
    //         [$svgIDs[0], $svgIDs[1]], // Second group with both IDs
    //         [$svgIDs[0]] // Single ID group
    //     ];
    // } elseif ($idCount == 3) {
    //     $combinations = [
    //         array_slice($svgIDs, 0, 2),
    //         array_slice($svgIDs, 1, 2),
    //         array_slice($svgIDs, 0, 1)
    //     ];
    // } elseif ($idCount == 4) {
    //     // For 4 IDs, create five groups of 1 ID each
    //     $combinations = [
    //         [$svgIDs[0]],
    //         [$svgIDs[1]],
    //         [$svgIDs[2]],
    //         [$svgIDs[3]],
    //         [$svgIDs[0]] // Repeating one ID to ensure 5 groups
    //     ];
    // } else {
    //     // For other counts (e.g., 5 or more), create a single group with all IDs
    //     $combinations = [$svgIDs];
    // }

    // $idss = [];
    // if ($idCount < 5) {
    //     foreach ($combinations as $combination) {
    //         foreach ($combination as $id) {
    //             $characters = DB::table('icons')->where('icon_id', $id)->first();
    //             if ($characters) {
    //                 $iconUrl = 'https://staggingdigiwiser.website/ai_project/dissertation_api/public/images/icons/' . $characters->icon_url;
    //               $idss[] = $characters->icon_id;
    //                 $url[] = file_get_contents($iconUrl, FILE_USE_INCLUDE_PATH);
    //             }
    //         }
    //     }
    // }
    //  else {
        foreach($svgIDs as $id)
        {
            $characters = DB::table('icons')->where('icon_id',$id)->first();
            $idss[] = $characters->icon_id;
            // $url[] =  file_get_contents('https://staggingdigiwiser.website/ai_project/dissertation_api/public/images/icons/' . $characters->icon_url,FILE_USE_INCLUDE_PATH);
    $url[] =  file_get_contents(url('images/icons/'.$characters->icon_url));
    
        }
    // }

    
    
        return response()->json(['icons' => $url,'icon_id' => $idss], 200);
}
public function downloadUserIcon($request)
    {
        $validator = Validator::make($request->all(), [
            'user_token' => 'required',
        'image' => 'required|string',
        ]);
        if ($validator->fails()) {
            $status_code = 400;
            $error_message = $validator->messages();
            return response()->json($error_message);
        }

        $tokenModel = PersonalAccessToken::findToken($request->user_token);

        // Check if token is valid
        if (!$tokenModel) {
            return response()->json(['error' => 'Invalid auth token'], 401);
        }
       $userId = $tokenModel->tokenable_id;

       $base64Image = $request->input('image');

        // Check if the base64 string contains metadata
        if (preg_match('/^data:image\/(\w+);base64,/', $base64Image, $matches)) {
            $imageType = $matches[1]; // Extract image type (e.g., png)
            $base64Image = preg_replace('/^data:image\/\w+;base64,/', '', $base64Image); // Remove metadata
        } else {
            return response()->json(['error' => 'Invalid base64 image data'], 400);
        }

        // Decode the base64 image data
        $imageData = base64_decode($base64Image);

        // Check if decoding was successful
        if ($imageData === false) {
            return response()->json(['error' => 'Base64 decoding failed'], 400);
        }

        // Generate a unique file name
        $fileName = Str::uuid() . '.' . $imageType; // Use the extracted image type
        $destinationPath = public_path('images'); // Path to public directory

        // Ensure the directory exists
        if (!file_exists($destinationPath)) {
            mkdir($destinationPath, 0755, true);
        }

        $filePath = $destinationPath . '/' . $fileName;

        // Write the file to the specified path
        $writeSuccess = file_put_contents($filePath, $imageData);

        if ($writeSuccess === false) {
            return response()->json(['error' => 'Failed to save image'], 500);
        }



        // if ($request->hasFile('image')) {
        //     $file = $request->file('image');
        //     $fileName = uniqid() . '.' . $file->getClientOriginalExtension();
        //     $destinationPath = public_path('images/user_logos'); // Path to public directory
        //     $file->move($destinationPath, $fileName);
        // }
        

        $details = [
            'user_id' => $userId,
            'downloaded_image' => $fileName
        ];

        UserDownloads::create($details);
        $data['status'] = "success";
        $data['message'] = "image downloaded succesfully";
        $data['image_path'] = url('/images');
        return response()->json($data,200);

    }
    
     public function userHistory($request)
    {
        $userID = auth('sanctum')->user()->id;
        $logos = UserDownloads::where('user_id',$userID)->get();
        $path = url('/images');

        return response()->json(['logos' => $logos, 'image_path' => $path], 200);

    }

}
