<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckUserSubscriptions
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user_package = auth('sanctum')->user();
        if ($user_package->stripe_id) {
            return $next($request);
        } else {
            return response(['status' => 'error', 'text' => 'Add Card and Buy Credits'], 404);
        }
    }
}
