<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\GenerateTextRepositoryInterface;
use Illuminate\Support\Facades\Validator;
use App\Http\Traits\UserTrait;
use App\Http\Traits\GenerateTrait;
use App\Models\AiLogos;
use App\Models\Dissertation;
use Illuminate\Support\Facades\DB;
use App\Models\Generate;
use App\Models\Documents;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class GenerateTextRepository implements GenerateTextRepositoryInterface
{
    use  UserTrait, GenerateTrait;
    public $check_auth;

    public function __construct()
    {
        $this->check_auth = $this->check_auth();
    }

    public function history_generator($request)
    {
            try{
                $packages = [];
                if($this->check_auth['user']->user_packages){
                    $data['status'] = "success";
                    foreach($this->check_auth['user']->user_packages as $key=>$value){
                        $packages[] = $value->id; 
                    }
                    $packages_data_ = Generate::whereIn('generate.user_package_id', $packages);
                    $packages_datas = Dissertation::whereIn('dissertation.user_package_id', $packages)->orWhere('user_id',$this->check_auth['user']->id)->get();   
                }else{
                    $packages_datas = "Package not found!";
                }
                $data['status'] = "success";
                $data['text'] = $packages_datas;
                return response()->json($data,200);
            }catch(\Exception $e){
                  $data['status'] = "error";
                  $data['text'] = $e->getMessage();
                     return response()->json($data,500);
            }
      
       
    }

    public function final_question($request)
    {
        $text = "";
        if ($request->type == 'topic') {
            $text .= "Suggest 15 dissertation topics for {$request->assigmentBrief}, and the subject area is {$request->SubjectArea}.";
        } else {
            $text .= "Generate text on : {$request->text} of {$request->pages_words} words and add list of {$request->style} reference at the end.";
        }
        return $text;
    }

    public function file__name($text)
    {
        $file_name = "";

        foreach (explode(' ', $text) as $key => $value) {
            if ($key <= 10) {
                if ($value != 'docx') {
                    $file_name .= $value . '.';
                }
            }
        }
        return implode(" ", explode('.', $file_name));
    }
    public function upload_documents($request)
    {
        try {
            $status_code = 404;
            $data['status'] = "error";
            $data['generation_id'] = "";
            $data['file'] = "";
            $data['message'] = "";
            return  DB::transaction(function () use ($request, $data, $status_code) {
                $validator = Validator::make($request->all(), [
                    'file' => 'required|mimes:doc,docx',
                    'generation_id' => 'integer|required',
                ]);
                if ($validator->fails()) {
                    $status_code = 400;
                    $error_message = $validator->messages();
                    if ($error_message->first('generation_id')) {
                        $data['generation_id'] = $error_message->first('generation_id');
                    } else {
                        $data['generation_id'] = $request->generation_id;
                    }
                    if ($error_message->first('file')) {
                        $data['file'] = $error_message->first('file');
                    } else {
                        $data['file'] = $request->text;
                    }
                    $data['message'] = $error_message;
                    return response()->json($data, $status_code);
                }
                $documents = new Documents();
                $datetime = date('YmdHis') . $request->generation_id;
                $documents->generated_id = $request->generation_id;
                $ext = $request->file->getClientOriginalExtension();
                $name = trim($this->file__name($request->file->getClientOriginalName())) . '.' . $ext;
                $path = $request->file('file')->storeAs('files/documents/' . $datetime, $name, 'public');
                $documents->documents = $path;
                $documents->save();
                $data['status'] = "success";
                $data['generation_id'] = "";
                $data['file'] = "";
                $data['message'] = "";
                return response()->json($data, $status_code);
            });
        } catch (\Exception $e) {
            $status_code = 500;
            $data['status'] = "error";
            $data['generation_id'] = "";
            $data['file'] = "";
            $data['message'] = $e->getMessage();
            return response()->json($data, $status_code);
        }
    }
    public function generateText($request)
    {
        try {
            $status_code = 404;
            $data['request'] = "";
            $data['text'] = "";
            $data['pages_words'] = "";
            $data['style'] = "";
            $data['status'] = "error";
            $data['output'] = "";
            $data['id'] = "";
            return  DB::transaction(function () use ($request, $data, $status_code) {
                if ($this->check_auth['status'] == 'success') {
                    $validator = Validator::make($request->all(), [
                        'text' => 'required|string|max:1000',
                        'pages_words' => 'required',
                        'style' => 'required'
                    ]);
                    if ($validator->fails()) {
                        $status_code = 400;
                        $error_message = $validator->messages();
                        if ($error_message->first('text')) {
                            $data['text'] = $error_message->first('text');
                        } else {
                            $data['text'] = $request->text;
                        }
                        if ($error_message->first('pages_words')) {
                            $data['pages_words'] = $error_message->first('pages_words');
                        } else {
                            $data['pages_words'] = $request->text;
                        }
                        if ($error_message->first('style')) {
                            $data['style'] = $error_message->first('style');
                        } else {
                            $data['style'] = $request->text;
                        }
                        return response()->json($data, $status_code);
                    }
                    $generate = new Generate();
                    $user_package_ids = "";
                    foreach ($this->check_auth['user']->user_packages as $key => $value) {
                        if ($value->total_counts >= 1) {
                            $user_package_ids = $value->id;
                            break;
                        }
                    }
                    $generate->user_package_id =  $user_package_ids;
                    $generate->text =  $this->final_question($request);
                    $generate->inputs =  json_encode($request->all());
                    $generate->save();
                    $data['status'] = "success";
                    if ($request->type == 'topic') {
                        $data['request'] = $request->assigmentBrief;
                    } else {
                        $data['request'] = $request->text;
                    }
                    $data['text'] =  $generate->text;
                    $data['output'] = Generate::find($generate->id)->output;
                    $data['pages_words'] = $request->pages_words;
                    $data['style'] = $request->style;
                    $data['id'] = $generate->id;
                    return response()->json($data, 200);
                } else {
                    $data['status'] = $this->check_auth['status'];
                    $data['status'] = $this->check_auth['status'];
                    $data['text'] = $this->check_auth['message'];
                    $data['output'] = "";
                    $data['pages_words'] = "";
                    $data['style'] = "";
                    $data['id'] = "";

                    return response()->json($data, $status_code);
                }
            });
        } catch (\Exception $e) {
            $data['request'] =  "";
            $data['status'] = "error";
            $data['text'] = $e->getMessage();
            $data['output'] = "";
            $data['pages_words'] = "";
            $data['style'] = "";
            return response()->json($data, 500);
        }
    }
     public function generate_dissertation($request)
    {

        try {
            $status_code = 404;

            $data['topic'] = "";
            $data['type'] = "";
            $data['totalWordCount'] = "";
            $data['methodology'] = "";
            $data['educationLevel'] = "";
            $data['disciplineMajors'] = "";
            $data['status'] = "error";
            $data['output'] = "";
            $data['id'] = "";
              $data['request'] =  "";
            return  DB::transaction(function () use ($request, $data, $status_code) {
                if ($this->check_auth['status'] == 'success') {
                    $validator = Validator::make($request->all(), [
                        'topic' => 'required|string|max:1000',
                        'totalWordCount' => 'required',
                        'methodology' => 'required',
                        'educationLevel' => 'required',
                        'disciplineMajors' => 'required',
                    ]);
                    if ($validator->fails()) {
                        $status_code = 400;
                        $error_message = $validator->messages();
                        if ($error_message->first('text')) {
                            $data['topic'] = $error_message->first('topic');
                        } else {
                            $data['topic'] = $request->topic;
                        }
                        if ($error_message->first('totalWordCount')) {
                            $data['totalWordCount'] = $error_message->first('totalWordCount');
                        } else {
                            $data['totalWordCount'] = $request->totalWordCount;
                        }
                        if ($error_message->first('methodology')) {
                            $data['methodology'] = $error_message->first('methodology');
                        } else {
                            $data['methodology'] = $request->methodology;
                        }

                        if ($error_message->first('educationLevel')) {
                            $data['educationLevel'] = $error_message->first('educationLevel');
                        } else {
                            $data['educationLevel'] = $request->educationLevel;
                        }
                        if ($error_message->first('disciplineMajors')) {
                            $data['disciplineMajors'] = $error_message->first('disciplineMajors');
                        } else {
                            $data['disciplineMajors'] = $request->disciplineMajors;
                        }
                        return response()->json($data, $status_code);
                    }
// 
                    $generate = new Dissertation();
                    $user_package_ids = "";


                    foreach ($this->check_auth['user']->user_packages as $key => $value) {
                        if ($value->dissertation >= 1) {
                            $user_package_ids = $value->id;
                            break;
                        }
                    }
                    
                    $generate->user_package_id =  $user_package_ids;
                    $generate->text =  $this->generate_dessertions($request);
                    $generate->save();
                    $data['output'] = Dissertation::find($generate->id)->output;
                    $data['id'] = $generate->id;
                    $data['status'] = "success";
                    $data['request'] = $request->topic;
                    $data['topic'] = $request->topic;
                    $data['totalWordCount'] = "";
                    $data['methodology'] = "";
                    $data['educationLevel'] = "";
                    $data['disciplineMajors'] = "";
                    return response()->json($data, 200);
                } else {

                    return response()->json($data, $status_code);
                }
            });
        } catch (\Exception $e) {
            $data['request'] =  "";
            $data['topic'] =  "";
            $data['status'] = "error";
             $data['output'] = $e->getMessage();
            $data['totalWordCount'] = "";
            $data['methodology'] = "";
            $data['educationLevel'] = "";
            $data['disciplineMajors'] = "";
            return response()->json($data, 500);
        }
    }
    public function theisesssss($request){
        
    } 
     public function theises($request)
    {
        try {
            $status_code = 404;
            $data['request'] = "";
            $data['text'] = "";
            $data['pages_words'] = "";
            $data['style'] = "";
            $data['status'] = "error";
            $data['output'] = "";
            $data['id'] = "";
            return  DB::transaction(function () use ($request, $data, $status_code) {
                if ($this->check_auth['status'] == 'success') {
                    // $validator = Validator::make($request->all(), [
                    //     'text' => 'required|string|max:1000',
                    //     'pages_words' => 'required',
                    //     'style' => 'required'
                    // ]);
                    // if ($validator->fails()) {
                    //     $status_code = 400;
                    //     $error_message = $validator->messages();
                    //     if ($error_message->first('text')) {
                    //         $data['text'] = $error_message->first('text');
                    //     } else {
                    //         $data['text'] = $request->text;
                    //     }
                    //     if ($error_message->first('pages_words')) {
                    //         $data['pages_words'] = $error_message->first('pages_words');
                    //     } else {
                    //         $data['pages_words'] = $request->text;
                    //     }
                    //     if ($error_message->first('style')) {
                    //         $data['style'] = $error_message->first('style');
                    //     } else {
                    //         $data['style'] = $request->text;
                    //     }
                    //     return response()->json($data, $status_code);
                    // }
                    // $generate = new Generate();
                    $user_package_ids = "";
                    foreach ($this->check_auth['user']->user_packages as $key => $value) {
                        if ($value->total_counts >= 1) {
                            $user_package_ids = $value->id;
                            break;
                        }
                    }
                
                     $output = "";
    $final_question = "Suggest 15 dissertation topics for {$request->assigmentBrief}, and the subject area is {$request->SubjectArea}.";
                        $details       = $this->getOutPutResult( $final_question);
                    
                       $generate = DB::table('dissertation')->insert(
                                ['user_id' => $this->check_auth['user']->id, 'text' =>$final_question , 'inputs' =>  json_encode($request->all()),'output'=>$details,'created_at'=>date('Y-m-d H:i:s'),'updated_at'=>date('Y-m-d H:i:s')]
                        );
                    
                    $data['status'] = "success";
                    if ($request->type == 'topic') {
                        $data['request'] = $request->assigmentBrief;
                    } else {
                        $data['request'] = $request->text;
                    }
                    $data['text'] =  $final_question;
                    $data['output'] = $details;
               
  
               
                    return response()->json($data, 200);
                } else {
                    $data['status'] = $this->check_auth['status'];
                    $data['status'] = $this->check_auth['status'];
                    $data['text'] = $this->check_auth['message'];
                    $data['output'] = "";
                    $data['pages_words'] = "";
                    $data['style'] = "";
                    $data['id'] = "";

                    return response()->json($data, $status_code);
                }
            });
        } catch (\Exception $e) {
            $data['request'] =  "";
            $data['status'] = "error";
            $data['text'] = $e->getMessage();
            $data['output'] = "";
            $data['pages_words'] = "";
            $data['style'] = "";
            return response()->json($data, 500);
        }
       
    }

    private function downloadAndSaveImage($imageUrl)
    {
        $response = Http::get($imageUrl);
        if ($response->successful()) {
            // Define the path and filename where you want to save the image
            $randomString = Str::random(20);

            // Extract the file extension from the URL
            $extension = pathinfo(parse_url($imageUrl, PHP_URL_PATH), PATHINFO_EXTENSION);

            // Create the filename with random string and extension
            $fileName = $randomString . '.' . $extension;
    

            // Define the path where you want to save the image
            $publicPath = public_path('images/' . $fileName);

            // Ensure the directory exists
            File::ensureDirectoryExists(public_path('images'));

            // Save the image to the specified path
            File::put($publicPath, $response->body());
            return $fileName;
        } else {
            return 'Failed to retrieve image. Status code: ' . $response->status();
        }
    }

    public function generatelogo($request)
    {
        try {
            $status_code = 404;
            $data['status'] = "error";
            $data['output'] = [];
            $data['id'] = "";
            return  DB::transaction(function () use ($request, $data, $status_code) {
                if ($this->check_auth['status'] == 'success') {
                    $validator = Validator::make($request->all(), [
                        'prompt' => 'required|string',

                    ]);
                    if ($validator->fails()) {
                        $status_code = 400;
                        $error_message = $validator->messages();
                        if ($error_message->first('prompt')) {
                            $data['prompt'] = $error_message->first('prompt');
                        } else {
                            $data['topic'] = $request->topic;
                        }
                        return response()->json($data, $status_code);
                    }

                    $generate = new Dissertation();
                    $user_package_ids = "";
                    foreach ($this->check_auth['user']->user_packages as $key => $value) {
                        if ($value->dissertation >= 1) {
                            $user_package_ids = $value->id;
                            break;
                        }
                    }
                   // $url = $this->generate_dessertions($request);
                    // $downloaded_file = [];
                    // foreach($url as $ur)
                    // {
                    //     $cleanurl = str_replace('<br>', '', $ur);
                    //     $downloaded_file[] = $this->downloadAndSaveImage($cleanurl);
                    // }
                    // $generate->output = json_encode($url);
                    // $generate->image_name = json_encode($downloaded_file);
                    $generate->user_package_id =  $user_package_ids;
                    $generate->text =  $request->prompt;
                    $generate->inputs =  json_encode($request->all());
                    $generate->user_id =   auth('sanctum')->user()->id;
                    $generate->save();    
                    $data['output']= Dissertation::find($generate->id)->output; 
                    $data['output'] =json_decode($data['output']);
                    $data['id'] = $generate->id;
                    $logos = AiLogos::where('dissertation_id',$generate->id)->get();
                    $data['status'] = "success";
                    // return response()->json($data, 200);
                    return response()->json(['data' => $data,'images' => $logos], 200);
                } else {

                    return response()->json($data, $status_code);
                }
            });
        } catch (\Exception $e) {
            $data['request'] =  "";
            $data['topic'] =  "";
            $data['status'] = "error";
             $data['output'] = $e->getMessage();
            return response()->json($data, 500);
        }
    }
 
   
}

