<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class CustomResetLinkMail extends Mailable
{
    use Queueable, SerializesModels;

    public $token;
    public $id;
    public $website;
    public $smtpSettings;
    
    /**
     * Create a new message instance.
     */
    public function __construct($token,$id,$website, $smtpSettings)
    {
        $this->token = $token;
        $this->id = $id;
        $this->website = $website;
        $this->smtpSettings = $smtpSettings;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Password Reset Link',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.custom_reset_link',
            with: [
                'token' => $this->token,
                'id' => $this->id,
                'website' => $this->website,
                'smtpSettings' => $this->smtpSettings,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
