<?php

namespace App\Observers;

use App\Models\Refer;
use App\Models\PaymentLogs;
use App\Models\UserPackage;


use App\Http\Traits\PaymentLogsTrait;
class ReferObserver
{
    /**
     * Handle the User "created" event.
     */
     use PaymentLogsTrait;
    public function created(Refer $refer): void
    {
        //
    }

    /**
     * Handle the User "updated" event.
     */
    public function updated(Refer $refer): void
    {
    \Log::info('start refer user');
    try{
        
        if($refer->wasChanged('used')){
            $refer = Refer::where('user_id',$refer->user_id)->orderBy('id','desc')->first();
            $user_packages = UserPackage::where('user_id',$refer->user_id)->orderBy('id','desc')->first();
              $userPackage = new PaymentLogs();
              $this->add_payment_logs_array($userPackage,[
                  'package_id'=>$user_packages->package_id,
                  'user_id'=>$refer->user_id,
                  'amount' =>  0,
                  'status'=>'unpaid',
                  'hits'=>$refer->hits,
                  'dissertation'=>$refer->dissertation,
                  'type'=>'refer'
                  ]);

        }
    }catch(\Exception $e){
     
    \Log::info($e->getMessage());
   
    }
    \Log::info('end refer user');
    }

    /**
     * Handle the User "deleted" event.
     */
    public function deleted(Refer $refer): void
    {
        //
    }

    /**
     * Handle the User "restored" event.
     */
    public function restored(Refer $refer): void
    {
        //
    }

    /**
     * Handle the User "force deleted" event.
     */
    public function forceDeleted(Refer $refer): void
    {
        //
    }
}
