<?php

namespace App\Observers;

use App\Models\User;
use App\Models\UserPackage;
use App\Models\Refer;
use App\Models\Website;
use App\Models\PaymentLogs;
use App\Models\Package;
use App\Http\Traits\PaymentLogsTrait;
class UserObserver
{
    use PaymentLogsTrait;
    /**
     * Handle the User "created" event.
     */
    public function created(User $user): void
    {
        
        
        $website = Website::where('id', $user->website_id)->first();
        $userPackage = new PaymentLogs();
        $free_package = Package::where('website_id', $user->website_id)->where('type','Free')->first();
        // $user_packages = UserPackage::where('user_id',$user->id)->orderBy('id','desc')->first();
        if($free_package->status == 'ACTIVE'){
            $this->add_payment_logs_array($userPackage,[
              'package_id'=>$free_package->id,
              'user_id'=>$user->id,
              'amount' =>  0,
              'status'=>'unpaid',
              'dissertation'=>$free_package->dissertation,
              'type'=> 'free',
              ]);   
        }
    }

    /**
     * Handle the User "updated" event.
     */
    public function updated(User $user): void
    {
      
        if($user->wasChanged('referred_by')){
            $refer = Refer::where('user_id',$user->referred_by)->orderBy('id','desc')->first();
            $user_packages = UserPackage::where('user_id',$user->id)->orderBy('id','desc')->first();
            $userPackage = new PaymentLogs();
                $this->add_payment_logs_array($userPackage,[
                  'package_id'=>$user_packages->package_id,
                  'user_id'=>$user->id,
                  'amount' =>  0,
                  'status'=>'unpaid',
                  'hits'=>$refer->hits,
                  'dissertation'=>$refer->dissertation,
                  'refered_by'=> $user->referred_by,
                  'type'=> 'refer',
                  ]);
        }
    }

    /**
     * Handle the User "deleted" event.
     */
    public function deleted(User $user): void
    {
        //
    }

    /**
     * Handle the User "restored" event.
     */
    public function restored(User $user): void
    {
        //
    }

    /**
     * Handle the User "force deleted" event.
     */
    public function forceDeleted(User $user): void
    {
        //
    }
}
