<?php

namespace App\Observers;

use App\Models\UserPackage;
use App\Models\PackageCounts;
use App\Http\Traits\PackageTrait;
class UserPackageObserver
{
    /**
     * Handle the UserPackage "created" event.
     */
    use PackageTrait;
    public function created(UserPackage $userPackage): void
    {
        $this->add_total_counts($userPackage);
    }

    /**
     * Handle the UserPackage "updated" event.
     */
    public function updated(UserPackage $userPackage): void
    {
        $this->update_total_counts($userPackage);
    }

    /**
     * Handle the UserPackage "deleted" event.
     */
    public function deleted(UserPackage $userPackage): void
    {
        //
    }

    /**
     * Handle the UserPackage "restored" event.
     */
    public function restored(UserPackage $userPackage): void
    {
        //
    }

    /**
     * Handle the UserPackage "force deleted" event.
     */
    public function forceDeleted(UserPackage $userPackage): void
    {
        //
    }
}
