<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Http\Interfaces\GenerateTextRepositoryInterface;
use App\Http\Repositories\GenerateTextRepository;
use App\Http\Interfaces\PackageRepositoryInterface;
use App\Http\Repositories\PackageRepository;
use App\Http\Interfaces\PaymentRepositoryInterface;
use App\Http\Interfaces\StripeSubscriptionRepositoryInterface;
use App\Http\Repositories\PaymentRepository;
use App\Http\Repositories\StripeSubscriptionRepository;
use App\Http\Interfaces\ReferRepositoryInterface;
use App\Http\Repositories\ReferRepository;
class RepositoryProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->bind(GenerateTextRepositoryInterface::class, GenerateTextRepository::class);
        $this->app->bind(PackageRepositoryInterface::class, PackageRepository::class);
        $this->app->bind(PaymentRepositoryInterface::class, PaymentRepository::class);
        $this->app->bind(StripeSubscriptionRepositoryInterface::class, StripeSubscriptionRepository::class);
        $this->app->bind(ReferRepositoryInterface::class, ReferRepository::class);
    }
    public function boot(): void
    {
        //
    }
}
