<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\PackageController;
use App\Http\Controllers\API\GeneratController;
use App\Http\Controllers\API\ReferController;
use App\Http\Controllers\API\StripeWebHookController;
use App\Http\Controllers\API\StripeSubscriptionController;
use App\Http\Controllers\API\ResetPasswordController;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Password;
use App\Models\User;
use App\Models\Website;
use Illuminate\Auth\Events\PasswordReset;;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::group(['prefix' => '/'], function () {
    
       Route::post('/contact-us',[AuthController::class, 'contact_submit']);
    
    Route::post('/forgot-password', [ResetPasswordController::class, 'sendResetLink'])
    ->middleware('guest')
    ->name('password.email');

    Route::get('check_token/{token}/{id}', [ResetPasswordController::class, 'check_token']);
   
    Route::post('/reset-password', function (Request $request) {
       
              $validator = Validator::make($request->all(), [
            'token' => 'required|string|max:255',
         
            'email' => 'required|string|email',
            'password' => 'required|string|min:8',
   
        
        ]);
        
       
        $data['email'] = "";
        $data['password'] = "";
        $data['status'] = "error";
        $data['message'] = "Validation error";
        if ($validator->fails()) {
            $status_code = 400;
            $error_message = $validator->messages();
            if ($error_message->first('email')) 
            {
                $data['email'] = $error_message->first('email');
            }
            if ($error_message->first('password')) 
            {
                $data['password'] = $error_message->first('password');
            }
           
            return response()->json($data, $status_code);
        }
        
        try{
            $website = Website::where('domain', $request->domain)->first();

            if (!$website) {
                return response()->json(['status' => 'error', 'message' => 'Domain not found in websites table.'], 404);
            }
            $user = User::where('email', $request->email)
                ->where('website_id', $website->id)
                ->first();

            if (!$user) {
                return response()->json(['status' => 'error', 'message' => 'User not found for the given domain.'], 404);
            }
            
            $status = Password::reset(
            $request->only('email', 'password', 'token'),
            function (User $user, string $password) {
                $user->forceFill([
                    'password' => Hash::make($password)
                ])->setRememberToken(Str::random(60));
                $user->save();
                event(new PasswordReset($user));
            }
        );
        return $status === Password::PASSWORD_RESET
            ? response()->json(['status'=>'success','message'=>'password updated successfully!'])
            : response()->json(['status'=>'error','message'=>'password not updated successfully!']);
        }catch(\Exception $e){
            response()->json(['status'=>'error','message'=>$e->getMessage()]);
        }
     
    })->middleware('guest')->name('password.update');

    
    Route::any('stripe/webhook',[StripeWebHookController::class,'index']);
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::post('/forget_password', [AuthController::class, 'forget_password']);
    Route::get('/package_list', [PackageController::class, 'package_list']);
    Route::group(['prefix' => '/', 'middleware' => ['CheckUserAuthentication']], function () {
        Route::post('/profile', [AuthController::class, 'profile']);
          Route::get('/profile', [AuthController::class, 'profile_']);
        // Route::post('/user_package', [PackageController::class, 'user_package']);
        // Route::post('/register_user_package', [PackageController::class, 'register_user_package']);
        Route::group(['prefix' => 'generate_text'], function () {
            Route::post('/', [GeneratController::class, 'store'])->middleware('CheckUserPackageExists');
            Route::post('/file_operation', [GeneratController::class, 'store_file']);
            Route::post('/theises', [GeneratController::class, 'theises']);
        });
        Route::group(['prefix' => 'generate_dissertation'], function () {
            Route::post('/', [GeneratController::class, 'dissertation'])->middleware(['CheckUserDissertationExists']);
        });
        Route::group(['prefix' => 'generate_dissertation'], function () {
            Route::post('/generate-logo', [GeneratController::class, 'generatelogo'])->middleware(['CheckUserAuthentication','CheckUserDissertationExists']);
        });
        Route::get('history', [GeneratController::class, 'history']);
        Route::post('download-user-icon', [GeneratController::class, 'downloadUserIcon']);
        Route::get('user-history', [GeneratController::class, 'userHistory']);


        // Route::group(['prefix' => 'package/{id}', 'middleware' => ['CheckUserLoggedin']], function () {
        //     Route::post('/get_package', [PackageController::class, 'register_user_package']);
        // });
 
        Route::get('/checkout', [PackageController::class, 'index'])->name('checkout.index');
        Route::post('/payment', [PackageController::class, 'stripePost'])->name('stripe.checkout')->middleware(['CheckUserAuthentication']);
        Route::get('/cancel', [PackageController::class, 'cancel'])->name('checkout.cancel');
    });
    Route::get('/plans', [StripeSubscriptionController::class, 'plans']);
    Route::get('plans/{plan}', [StripeSubscriptionController::class, 'show'])->name("plans.show")->middleware(['CheckUserAuthentication','CheckReferLink']);
    Route::post('subscription', [StripeSubscriptionController::class, 'subscription'])->name("subscription.create")->middleware(['CheckUserAuthentication']);
    Route::get('user_subscriptions', [StripeSubscriptionController::class, 'user_subscriptions'])->name("subscription.user_subscriptions")->middleware(['CheckUserAuthentication','CheckUserSubscriptions']);
    Route::post('default',[StripeSubscriptionController::class, 'default'])->name("subscription.default")->middleware(['CheckUserAuthentication']);
    Route::post('add_credits', [StripeSubscriptionController::class, 'add_credits'])->name("subscription.add_credits")->middleware(['CheckUserAuthentication','CheckUserSubscriptions']);
    Route::post('/add_new_card', [StripeSubscriptionController::class, 'add_new_card'])->name("subscription.add_new_card")->middleware(['CheckUserAuthentication','CheckUserSubscriptions']);
    Route::post('cancel_subscriptions', [StripeSubscriptionController::class, 'cancel_subscriptions'])->name("subscription.cancel_subscriptions")->middleware(['CheckUserAuthentication','CheckUserSubscriptions']);
    Route::post('resum_subscriptions', [StripeSubscriptionController::class, 'resum_subscriptions'])->name("subscription.resum_subscriptions")->middleware(['CheckUserAuthentication','CheckUserSubscriptions']);
    Route::group(['prefix' => 'refer', 'middleware' => ['CheckUserAuthentication']], function () {
        Route::get('/get', [ReferController::class, 'index']);
        Route::post('check_refer', [ReferController::class, 'check_refer'])->name('refer.check');
    });
    Route::post('/client_order',[StripeSubscriptionController::class,'client_order'])->name('clients.order')->middleware(['CheckUserAuthentication']);
    
        // Route::post('/generate-logo', [StripeSubscriptionController::class, 'generatelogoai'])->name('generate.logo');
            // Route::post('get-svg',[StripeSubscriptionController::class,'getSvg']);

                Route::get('/get-characters', [StripeSubscriptionController::class, 'getCharacter'])->name('get-characters');
                Route::post('get-svg', [GeneratController::class, 'getSvg']);


    
});

